# 第九章 开源贡献

时至今日，在全球开源界普遍认同中国企业和中国开发者对全球开源产业贡献巨大的背景下，依然有许多国内人士认为中国是全球开源资源的索取者和使用者，这是成见，更是偏见。
事实上，在20世纪90年代中期，中国开源还处于启蒙阶段，国内最早接触这一领域的技术先驱者尝试积极参与国际开源社区的代码共享活动，虽然是凤毛麟角，但星星之火终成燎原之势。
21世纪初，随着国内Linux系统和LAMP技术栈的兴起，中国开源进入萌芽阶段，一些全球知名企业在华研究机构成建制地组织中国开发者，系统地参与到国际知名开源社区中。国内开源社区如雨后春笋般层出不穷，开源文化在当时那一批20岁出头的中国开发者心中埋下了种子。
时间来到2008年，这一年是中国开源发展史上的重要里程碑，Linux基金会、GNOME基金会、Apache软件基金会以及OpenOfﬁce基金会不约而同地选择在北京举办相关技术峰会，实现了他们登录亚洲的首秀。因此，2008年成为一个重要的转折点，全球开源界已经承认中国的开源贡献者地位，中国开源的第三个发展阶段随之到来。
在过去13年中，中国开源开发者开始习惯于用流利的英语和全球开源人士分享他们的技术经验。根据中国开源软件推进联盟统计，在2016年至2017年在华召开的开源国际会议上发表的论文中，来自国内和国外的的论文比例为4：6，即有40%的开源论文来自中国开发者。
中国的开源力量正在以惊人的速度迎头赶上，在开源开发者贡献度、开源社区活跃度、开源基金会参与度等方面，我们均已取得不俗的成绩。这些来自中国的开发者和科技企业正在向全世界呈现全新的中国印象，中国逐步实现了开源世界的大国担当。
本章将引用全球知名开源基金会和业内最具代表性的开源社区的详实数据，来呈现开源世界的中国贡献，以及国际企业对中国开源发展所带来的推动作用。

## 9.1 国际开源社区的中国贡献

### 9.1.1 中国开发者已经成为Kernel.org社区最大贡献群体
在开源世界中，Kernel.org社区的象征意义无可替代，开源界的创世一代至今依然活跃在这个社区，因而Kernel.org至今仍常被作为一个开源指数来度量一个企业或一个区域的开源繁荣和发展程度。
为更加全面地展示中国在开源领域的成长过程，我们分别通过中国开发者和中国科技企业对Kernel.org社区的补丁贡献数据来呈现(见图28)。

图28 中国开发者对Kernel.org社区的贡献数据和贡献度排名（2005年6月至2022年2月）
为了更直观地呈现内核社区中中国开发者的参与度和贡献度的变化，我们节选了部分版本的贡献度进行对比，从表22可看出，在过去的16年间，参与Kernel.org社区的中国开发者的规模提升了34倍， 对社区的贡献绝对数量提升了34.76%，对Kernel.org的贡献排名近五年来保持世界第一。

表22 部分版本贡献度对比（数据采集截至2022年2月21日）
在统计过程中，我们还有一些发现。通过对比12年来中国开发者数量的变化，可以推算出中国开发者对Kernel.org社区的人均贡献度，其整体变化如图29所示。

图29 中国开发者对Kernel.org社区的人均贡献度（2005年6月至2022年2月）
通过对比最近三个内核版本排名前三国家的开发者人数和人均贡献值(见表23)，可以发现现今中国开发者的人均贡献度远小于德国和美国，进而我们可以推断出未来中国开发者的人均贡献度和绝对贡献数量还有很大提升空间。

表23 Kernel.org社区三个内核版本排名前三国家的开发者人数和人均贡献值
纵观Kernel.org社区总体的开发者贡献，我们会发现中国、美国、德国、英国、法国、印度是该社区的主要贡献群体，其中中国的发展速度远远超过上述其他国家(见图30)。

图30 主要国家开发者在Kernel.org社区的贡献排名（2005年6月至2022年2月）
从另一个角度，我们同样可以发现中国企业在Kernel.org社区中的贡献度越来越大，相关排名持续上升，图31是2017年2月至2022年2月的中国企业内核社区贡献排名。

图31 十大中国企业在Kernel.org社区中的贡献排名（2017年2月至2022年2月）
此外，联想、酷派、麒麟软件和小米均对内核社区有贡献。

### 9.1.2 中国开发者成为RISC-V生态中不可或缺的组成部分
2011年5月，加州大学伯克利分校研究团队发布了一套全新的开放指令集RISC-V(见图32)。2015年，汇聚全球100多家单位的非营利组织RISC-V基金会正式成立。

图32 RISC-V指令集
为降低潜在的技术出口法律限制风险，减轻来自地缘政治的潜在破坏，同时为确保基金会更加中立、开放和包容，RISC-V基金会将注册地迁移至瑞士，此举受到全球RISC-V爱好者的广泛好评。RISC-V基金会的日常运营由董事会负责，由四名常委和十六名委员构成，其中的中方委员有九名(见表24)，占比达到45%。

表24 RISC-V理事会中方委员
在RISC-V这一轮发展浪潮中，中国企业、高校和科研机构发挥了巨大作用。有数据显示，中国有超过400家企业关注、参与和使用RISC-V指令集进行开发。据统计，在RISC-V基金会中，成员分为三个层次(见表25)，在基金会核心成员( Premier Member)中，中方成员占比达到57.9%。在战略成员(Strategic Member)中，中方成员占比达到26.8%，在社区组织成员(Community Organization Member)中，中方成员占比达到7.6%。

表25 RISC-V理事会中方成员    
特别是2018年以来，RISC-V在中国的发展呈现加速之势，以下为相关标志性事件。
2018年2月，《RISC-V手册》中文版出版。
2018年5月，胡振波撰写的《手把手教你设计CPU——RISC-V处理器》正式出版。
2018年7月，上海经信委出台了国内首个支持RISC-V的政策。
2018年9月，中国RISC-V产业联盟在上海成立。
2018年9月，华米科技发布基于RISC-V的可穿戴处理器“黄山1号”。
2018年11月，中国开放指令生态(RISC-V)联盟在乌镇成立。
2019年1月，《开放指令集与开源芯片发展报告》发布。
2019年6月，世界智能计算机大会开源芯片论坛在深圳举办。
2019年7月，阿里平头哥正式发布RISC-V处理器玄铁910。
2019年9月，中国开放指令生态联盟联合BenchCouncil举办RISC-V国际智能系统大赛。2019年10月，阿里平头哥宣布开源RISC-V的MCU平台无剑100 Open。
2019年10月，卡姆派乐发布RISC-V集成开发环境-卡姆派乐IDE。
2019年11月，清华-伯克利深圳学院设立RIOS实验室，图灵奖得主大卫帕特森领衔。2019年11月，中国RISC-V论坛在深圳召开。
2020年1月，上海交通大学与上海瓶钵信息科技有限公司开源了基于RISC-V架构的TEE安全系统“蓬莱”。
2020年3月，兆易创新GD32MCU获Embedded Award 2020国际顶级大奖。
2020年4月，芯来科技发布“Nuclei RISC-V大学计划”。
2020年6月，“香山”开源高性能处理器项目启动。
2020年6月，华米科技发布基于RISC-V的“黄山2号”可穿戴AI芯片。
2020年7月，中国开放指令生态联盟举办2020年度联盟技术研讨会。
2020年7月，中国科学院大学发布针对RISC-V处理器的“一生一芯”计划。
2020年8月，卡姆派乐公司开源RISC-V向量LLVM编译器。
2020年8月，RIOS发布全球首个运行Linux的RISC-V开源边缘计算平台PicoRio。
2021年8月，中科院软件所与RISC-V国际基金会联合上线全球首个面向开源社区的RISC-V构建验证平台RISC-V Lab。
2020年9月，RIOS的曹野移植Chromium OS到RISC-V。
2020年9月，赛昉科技发布基于RISC-V人工视觉处理平台——惊鸿7100。
2020年11月，RT-Thread发布RISC-V的国产集成开发环境RT-Thread Studio。
2020年11月，千芯科技发布针对芯来RISC-V平台的AI部署工具包(tinyAI SDK)。
2020年12月，芯来科技推出开源RISC-V处理器教学平台——蜂鸟E203 SoC。
2021年1月，阿里平头哥为RISC-V移植安卓10系统并开源。
2021年2月，平头哥携手阿里云天池举办“RISC-V应用创新大赛”。
2021年3月，中科蓝讯RISC-V指令集蓝牙芯片累计超过10亿颗。
2021年4月，芯来科技为RISC-V移植了鸿蒙LiteOS-M内核。
2021年5月，华为海思推出基于RISC-V的Hi3861的开发板。
2021年6月，阿里平头哥推出三款RISC-V开发板，分别支持Android、Linux、AliOS Things。2021年6月，首届RISC-V中国峰会在上海召开。
2021年7月，“香山”第一版处理器“雁栖湖”(28nm)正式流片。
2021年8月，赛昉科技累计融资10亿元。
2021年9月，睿思芯科完成A轮数千万美金投资。
2021年10月，阿里平头哥开源四款RISC-V处理器E902、E906、C906和C910。2021年10月，2021 RISC-V Taipei Day召开。
2021年11月，中国科学院软件研究所《RISC-V指令集架构研究综述》论文发表。
2021年12月，赛昉科技发布RISC-V CPU Core IP“昉·天枢”和“昉·星光”RISC-V单板计算机。2021年12月，阿里平头哥宣布RISC-V玄铁处理器累计出货超过25亿颗。
2021年12月，华为海思基于RISC-V发布Hi373V110电视芯片及LiteOS。
在上述标志性事件中，我们可以看出，在2018年12月RISC-V基金会首次宣布要迁至瑞士后，中国企业界和学术界加速了参与和融入RISC-V基金会的进程，其中中国RISC-V产业联盟和中国开放指令生态(RISC-V)联盟发挥了巨大的促进作用。自2020年开始，中国国内的RISC-V生态快速完善，并开始涌现越来越多的RISC-V产业化案例。
众所周知，中国一直在芯片领域处于受制于人的窘境，整个产业迫切走出一条自力更生、自主创新之路。RISC-V由于开源的特性，自诞生起就在中国产业界备受瞩目，大量中国芯片公司正在成为RISC-V的拥趸，加大对RISC-V的投入。而中国具备的电子制造业生态优势，也成为RISC-V应用前景最乐观的地区，RISC-V在中国的市场容量和发展潜力巨大。这些因素成就了双方“互利互助、合作共赢”的天作之合。
另外，RISC-V生态中的相应软件、工具链还有待完善。RISC-V指令集开源并不意味着CPU核心也同时免费授权，这对芯片公司提出了很高的设计和研发要求。客观上，目前RISC-V只是帮中国芯片产业走上快车道，但前路漫漫，还需要我们持续努力。在未来的RISC-V生态建设中，中国企业需要平心静气、戒骄戒躁，避免在资本的推动下过度炒作概念，同时加强全球产业合作，避免产业生态碎片化趋势。

### 9.1.3 中国用户和开发者已经成为OpenCV社区的中坚力量

最近十年，中国成为开源计算机视觉软件OpenCV最大用户。根据Sourceforge.net的统计（见图33），2012年中国下载量排在美国、日本之后。2013年开始，中国超越美国和日本位居第一。此后，中国下载量占全球比例持续增加，至2022年已达44%，即全球下载量超过四成来自中国。随着人工智能领域的发展，中国已经成为OpenCV第一大用户，远超其他国家。

图33 OpenCV四国年度下载量

OpenCV最初由Intel公司在俄罗斯的研发团队开发，于2000年正式对外发布。现在OpenCV已由OpenCV基金会社区化运作，有来自全世界各地的开发者为之贡献代码。由于历史原因，很多关键功能都是由来自俄罗斯的开发者提供。这些开发者或来自俄罗斯的Intel、Xperience.ai等公司。

与此同时，在OpenCV社区中的中国开发者贡献比例也在起伏攀升（见图34）。以Google Summer of Code为例，2011年至2023年，Google共资助OpenCV 141个项目，其中31个由中国开发者承担，占比 22.0%；最近两年更是达到50%。OpenCV的Area Chair，是一 个招募高级科学家为OpenCV做算法贡献的社区项目，据2022年OpenCV春季公的首批OpenCV Area Chair，共有9人，其中4名是中国科学家，占比44.4%。 
2019年，OpenCV中国团队成立，得到深圳市人工智能与机器人研究院和南方科技大学的支持。

OpenCV近两年在中国的发展得益于OpenCV中国团队的助力，该团队现在共有全职人员5人，致力于引导中国开发力量为OpenCV做贡献，使中国科研成果普惠全世界；同时改进OpenCV使之适应未来的应用，特别是机器 人相关应用，促进科研成果快速落地。

图34 历年OpenCV GSoc项目中国开发者比例

最近两年，中科院软件所、阿里平头哥公司为OpenCV贡献了非常核心的RISC-V CPU支持；腾讯公司为OpenCV贡献了QR二维码扫码算法；南方科技大学、北京邮电大学、大连理工大学、华中科技大学、深圳大学等高校为OpenCV贡献了大量关键视觉算法。

##9.2 中国企业在开源基金会中发挥重要作用

### 9.2.1 中国成员在Apache软件基金会（ASF）的参与度

截至2022年6月，Apache软件基金会源自中国的活跃开源项目共28个，其中有17个项目成为了顶级项目。分别是：

Apache Doris(2018/07/18-2022/6/15)
Apache InLong(原TubeMQ，2019/11/03-2022/6/15)
Apache DolphinScheduler(2019/8/29-2021/04/08)
Apache ECharts(2018/1/18-2020/12/16)
Apache Ozone(2018/11-22-2020/10/21)
Apache IoTDB(2018/11/18-2020/9/17)
Apache APISIX(2019/10/17-2020/07/15)
Apache ShardingSphere(2018/11/10–2020/4/16)
Apache Submarine(2019/10/16,Hadoop spin-off)
Apache Dubbo(2018/2/16–2019/5/15)
Apache Skywalking(2017/12/8–2019/4/17)
Apache Grifﬁn(2016/12/5–2018/11/21)
Apache ServiceComb(2017/11/22–2018/10/17)
Apache HAWQ(2015/9/4–2018/8/15)
Apache RocketMQ(2016/11/21–2017/9/20)
Apache CarbonData(2016/6/3–2017/4/19)
Apache Kylin(2014/11/25–2015/11/18)

在Apache软件基金会孵化项目中，中国项目有11个，2021年、2022年截至4月分别有5个和3个新项目进入到ASF项目孵化器。11个孵化项目分别是：

Apache DevLake(2022/04/29)
Apache Kvrocks(2022/04/23)
Apache HugeGraph(2022/01/23)
Apache SeaTunnel(2021/12/09)
Apache Linkis(2021/08/02)
Apache Kyuubi(2021/06/21)
Apache ShenYu(2021/05/03)
Apache EventMesh(2021/02/18)
Apache Pegasus(2020/06/22)
Apache Teaclave(原MesaTEE,2019/08/19)
Apache brpc(2018/11/13)

ASF全球有800余位成员，目前已知并互动较为频繁的中国及华人成员有29位。其中，姜宁在2022年3月ASF举行的成员会议上被选举成为新任董事。
Apache软件基金会现有中国企业赞助商6家(见表26)，分别是白金赞助商：华为、腾讯云；黄金赞助商：百度；白银赞助商：阿里云、滴滴出行；银牌赞助商：小米。

表26 Apache基金会中国赞助商明细表

### 9.2.2 中国成员在Linux基金会（LF）的参与度
Linux基金会董事会成员共23人，其中中国成员2人，占比为8.6%。分别为华为的侯培新与腾讯的刘鑫。
Linux基金会目前共有中国会员139家(见表27)，相较于2020年的70家增涨了98.6%。其中白金会员2家(约占14.3%)；黄金会员3家(约占16.7%)；白银会员112家(约占9.5%)；Associate(准会员)22家(约占7.9%)。

表27 LF中国成员单位明细表

### 9.2.3 中国成员在云原生计算基金会（CNCF）的参与度
据CNCF的统计，超过20%的开源项目来自中国，贡献度排名上升至世界第二。在云原生应用上，68%的机构在生产过程中使用容器，31%的开发者称所在单位的容器使用量已经超过5000个。CNCF理事会共29名成员，其中中国成员2人，分别是阿里巴巴的李毅和火山引擎(字节跳动)的张鑫。
CNCF基金会目前共有中国会员84家(见表28)，其中包括3个白金会员(占13.6%)、10个黄金会员(占40%)、67个白银会员(占11.1%)、1个研究院所(占25%)，以及3个最终用户会员(占2.9%)。中国会员目前占CNCF总数的10.7%，较2021年统计增长了2.7%。

表28 CNCF中国成员明细表	　	　

### 9.2.4 中国成员在开源基础设施基金会（OIF）的参与度
OIF基金会董事会27人，其中中国成员11人(占40.7%)。分别为烽火通信陈刚；易捷行云李中华、林冠宇；中国移动焦鹏举；中国联通钟忻；英特尔练丽萍、王伟；九州云李开；腾讯任钟坪；蚂蚁集团王旭；华为任旭东。OIF现有中国成员中包括白金会员4家(占44%)；黄金会员9家(占53%)；白银会员1家(2.2%)；支持机构14家(占4%)，见表29。

表29 OIF社区中国成员明细表

### 9.2.5 中国成员在开源发明网络社区（OIN）的参与度
目前OIN社区现有中国成员共125个(见表30)，较2021年统计增长26%。

表30 OIN 社区中国成员明细表（部分）

## 9.3 中国头部科技企业的开源贡献

### 9.3.1 华为
华为公司是国内最早建立开源战略管理的企业之一，在开源合规、企业内源、全球开源贡献、社区融入和技术引领等方面位居国内企业前列。华为是Apache软件基金会、Eclipse基金会、Linux基金会、开放原子开源基金会、OIF基金会等数十个国际开源基金会的顶级成员或初创成员，服务数十个董事席位，以及数百个TSC、PMC、PTL、Maintainer、Core Committer席位。
近两年来，面向云原生、自动化和智能化，华为又先后开源了EdgeGallery、MindSpore、Karmada、openEuler、openGauss、OpenHarmony等多个平台级基础软件开源项目。其中openEuler、OpenHarmony开源项目捐赠给开放原子开源基金会，Karmada开源项目捐赠给CNCF基金会，全球超过1000个城市的用户下载使用这些开源软件。
华为持续投入openEuler、openGauss、OpenHarmony、MindSpore开源项目生态建设，openEuler社区吸引近万名开发者、300+家企业加入，主流操作系统厂家发行11个商业发行版，openEuler商用已经突破100万套；openGauss社区开发者2500+，100家组织加入社区，已发布12个商业发行版，6大行业推广使用10000+套；华为累计贡献500多万行OpenHarmony核心代码，社区吸引30000+名开发者和40家企业参与代码贡献，生态设备发货量1亿+，已在12个行业探索落地；MindSpore社区开发者80万+，新增160+家企业成员，服务5000+家企业。2021年，华为启动“开源雨林”计划，携手国内多家开源组织和科研机构，共同构建面向企业开源理念和治理的社区，帮助国内企业理解开源文化，合理合规使用开源，共同构筑国内开放共赢的健康开源生态。
同时，华为致力于健全社区生态治理架构，确保有序演进。通过社区度量反馈机制，及时了解开发者反馈，持续优化社区治理机制。引入AI技术辅助社区运营，对社区基础设施进行技术优化和智能化，提升用户体验。将优秀编码规范、流程、工具链等引入社区，源源不断地为社区注入活力。基于开源协作的创新模式推动产业生态构建，共建多样性、包容性、可信的开源生态。
重点开源贡献
OpenHarmony ：这是由开放原子开源基金会孵化及运营的开源项目，目标是面向全场景、全连接、全智能时代。基于开源的方式，搭建一个智能终端设备操作系统的框架和平台，促进万物互联产业的繁荣发展。OpenHarmony最新版本为v3.1，发布于2021年12月30日。更新了23个领域关键特性、20块开发板，累计204个开发样例。截至目前，已成立38个SIG；代码贡献者1783人；贡献单位共计40家；已有25家机构完成捐赠，募集捐赠款1250万元。陈海波、中科院软件所武延军、51CTO张荣超、深开鸿张兆生、华为贾宁、上海交大臧斌宇、华为李英伟7人被选举为OpenHarmony TSC(Technical Steering Committee技术指导委员会)成员；OpenHarmony PMC(Project Management Committee项目管理委员会)扩容至19人；工作委员会成员扩至8家；活动与营销工作组有38家单位成员，6大开发者社区专区建设(CSDN、51CTO、开源中国、思否、电子发烧友、InfoQ)，104个高校阵地(有组织者的高校)。已有2000人进入“OpenHarmony成长计划”并作为布道师进行培养。已将所有生态进展集结成册，形成《OpenHarmony生态专刊》(144页)，2021年12月28日印刷并在南京OpenHarmony开发者见面会首次分发。
异思MindSpore ：通过社区合作，面向全场景构建最佳匹配、支持多处理器架构的开放AI架构，为算法工程师和数据科学家提供开发友好、运行高效、部署灵活的体验。目前，昇思MindSpore下载量已超130万，4000+社区贡献者，5000+企业应用上线。其中手机应用日均7亿+调用量，300+主流网络模型实现。在码云上，MindSpore社区共有21个仓库，总Star数达到1.6万+，总PR数超5.2万，主仓库Gitee指数为96分，领跑同类项目。
openEuler ：这是由开放原子开源基金会孵化及运营的开源项目。通过社区合作，打造创新平台，构建支持多处理器架构、统一和开放的操作系统openEuler。2021年9月25日OpenEuler全新发布，同时支持服务器、云计算、边缘计算、嵌入式等各种形态设备的需求。支持多样性计算，致力于提供安全、稳定、易用的操作系统；并通过为应用提供确定性保障能力，支持OT领域应用及OT与ICT的融合。至此全新发布的欧拉操作系统可覆盖从IT、CT到OT数字基础设施全场景。作为国内最活跃的开源社区，已有300家以上头部企业加入，8000多名社区开发者持续在社区贡献，90个以上SIG，8000多个代码仓。截至2021年12月31日，个人贡献者占比累计近40%，企业贡献占比累计超60%。其中，万级以上PR贡献企业一名(华为技术)，千级PR贡献企业两名(麒麟、统信)。OpenEuler下载使用用户超过37万。主流操作系统厂商，如麒麟、统信、SUSE、麒麟信安、普华、中科创达等均已发布基于openEuler商业发行版，这些发行版已在及金融、运营商、电力、政府信息中心等重点行业核心系统达90万套以上规模落地。

### 9.3.2 阿里巴巴
阿里开源进展
随着历史的发展以及阿里在开源侧实践的深入，阿里巴巴对开源的认知也一直在演进。阿里认为，开源+云计算共同构成了数字世界的根，站在用户的视角，云平台与开源社区的有效合作，赋予了用户灵活的选择权。而阿里巴巴开源的独特的生命力在于“三位一体”，三位一体是指阿里自用的技术、社区开源的技术和阿里云对客户提供的技术是一个版本 ——“三位一体”的方式使得自研、开源与云计算商业形成血脉相通的整体。阿里通过集团业务自行验证，再对外开源的策略，构建起一个良性的开源生态。
开源是阿里的技术战略之一，阿里是开源的受益者，也主动回馈开源、引领开源。在阿里开源委员会的指导下，明确了阿里开源的五大主要领域：云原生，AI大数据，数据库，操作系统和终端。在这些领域中，2022年有很多新的重磅开源项目涌现出来，比如专门解决应用混布的Koordinator，低代码框架LowCodeEngine，开源大模型平台 ModelScope，阿里搜索的重点产品Havenask，云原生数据库PolarDB-for-PostgreSQL等等。而我们原有的优势项目，比如 Apache Flink , Apache Dubbo，Apache RocketMQ ，Nacos等我们也在持续的保持投入与贡献，当前在云原生CNCF这个细分的领域，开源协作影响力指标（OpenRank）已经位列第二，国内第一；作为我们面向云时代的开源操作系统 -- 龙蜥操作系统，也从自主创新走向开源共建，正式进入高质量发展黄金期，成立至今，已经有24家社区理事单位，300+ 家合作伙伴，获得40+ 个产业奖项，54个社区技术SIG 组、230万+ 下载量、300万+ 装机量、累计30万+ 用户。
全球影响力
目前，阿里已累计对外开源了上百个优秀/精品项目，全球超过3万开发者为开源项目贡献代码，在GitHub上Star总数超百万。在开源协作影响力（OpenRank）表现上，CNCF Landscape的 580个开源项目中，由阿里巴巴发起的云原生项目群数据遥遥领先，全年参与的开发者和新增贡献者数量均超过了其他中国企业的总和；在中国企业发起并捐献到Apache基金会的项目中，阿里巴巴凭借Apache Flink、Apache Dubbo、Apache RocketMQ等顶级项目同样占据榜首。
国内影响力
（1）《2022 开源年度报告》显示，阿里依旧保持中国企业开源协作影响力（OpenRank）、活跃度双第一。
（2）2023年1月，阿里巴巴主导的Apache Flink、Apache Dubbo、龙蜥操作系统、Seata、Nacos等多个开源项目通过了工信部电子标准院的成熟度评估，并获得“优秀”评级。
（3）2022年，阿里巴巴获得“中国信通院 - OSCAR尖峰开源企业（开源运营与生态建设）”，并经信通院认证成为“可信开源合规计划正式成员”。
（4）阿里云获得中国信通院 - “可信开源供应链 & OpenChain”双评估证书，在中国开源云联盟(COSCL)组织的2022年度评选活动中获“优秀开源创新企业”。
阿里巴巴开源办公室
2022年核心职能：开源办公室的主要职责是与开源委员会互相配合，把开源委员会制定的技术战略在阿里巴巴落地和执行，并保障更多开源项目的治理和运营。通过制定规则及流程机制，对团队进行核心培训从而明确底线，并且做到有迹可查，全面提高技术同学的安全合规意识，加强开源社区的规范建设和管理，保障阿里的开源项目安全、可靠地为开发者、企业服务。
2022年重点进行了三方面的工作：
1.将开源与企业核心的业务战略或者技术战略相结合，从之前“自下而上”的开源模式逐步转变成“自下而上、自上而下”二合一的模式，以此来保障阿里明确战略方向上要投入的开源软件不会出现后续无人维护的情况。
首先，新的项目要开源，需要该领域的开源委员会副主席进行技术判断；其次，对于团队内自下而上的开源模式，阿里巴巴依旧全力鼓励，并会给与一定的孵化资源，自上而下不意味着严格控制开源，而是要在鼓励开源开放的同时，做好治理与扶持工作。最后，从项目管理视角建立完善的开源项目治理框架，对开源项目分阶段、分类型进行精细化治理，建立系统的业务平台，有效厘清与甄别开源项目的生命周期，对处于不同阶段的项目进行具有针对性的治理与指导工作。
对于孵化期开源项目，做到能开尽开，保证法务、安全合规工作，加强开发团队的开源教育与指导，扶持社区健康快速发展。对于稳定发展的开源项目，做好规模化社区的流程建设，加强社区中的技术合作与发展，持续服务好社区用户。对于因技术或业务原因停止维护的项目，设计开源项目的退出机制，做好社区通知声明与项目归档工作，站好最后一班岗。
通过上述治理工作，在鼓励自下而上开源开放的同时，保证自上而下的宏观治理工作有序落地，在保证项目质量与生命周期管理中加速阿里的优秀内部技术实践往开源转化，为开源技术生态的发展添砖加瓦。
2.通过战略引导明确核心开源领域，并设置多领域的负责人共同评估、判断某一开源项目，并推进开源战略的落地。为了保证开源项目的专业性判断，开源委员会一共新设立了 9 位领域副主席，可称得上是各自领域的“一号位”，除了深厚的技术专业知识，他们本身就具备足够多的团队及资源，可以帮助公司内部做出更好的技术支持及专业判断，从而帮助相关技术领域孵化出更多创新产品，为行业输出更多优秀的开源项目。
3.对存量开源项目进行更全面、规范的治理。夯实阿里巴巴“开放、有序、踏实、利他”的开源文化，让阿里巴巴的开源行动也需要变得更加有系统、有组织、可持续。
两大活动（编程之夏，阿里开源开放周）
编程之夏：2022年5月30日，第三届阿里巴巴编程之夏面向高校学生开放报名，阿里巴巴编程之夏（ASoC）是面向全球18岁及以上本科、硕士、博士高校学生的技术普惠计划，它旨在鼓励高校学生深度参与开源开发活动，激励学生以第一视角感受开源世界的魅力。ASoC 以阿里巴巴开源技术力量作为媒介，为高校学生们和开源社区搭建桥梁。
本次活动获得CCF开源委员会秘书长章文嵩、Apache Software Foundation 董事吴晟等开源圈大佬点赞转发，发布后有北大开源协会、清华TUNA开源协会、西电开源协会等学生社团主动接洽。除了国内顶级高校清华大学、北京大学、中国科学技术大学等，top20 985高校覆盖率达到了85%以上。另外还有14所国际高校学生报名。包括约翰霍普金斯大学、卡耐基梅隆大学、加州大学圣地亚哥分校、纽约大学、东北大学、伊利诺伊大学厄巴纳香槟分校、巴黎综合理工学院、加拿大阿尔伯塔大学、欧洲英国诺丁汉大学、丹麦科技大学、印度德里技术大学等。和往届编程之夏相比，覆盖项目领域从前端、云原生、大数据领域扩展到 操作系统、大数据、数据库、云原生、前端、人工智能等热门领域。项目数量从去年的20个增加到27个，开放任务数量从62个增加到96个。
开源开放周：2022首届阿里开源开放周Alibaba Open Source Week于2022年8月22-24日以线上的形式亮相，邀请了业界顶尖技术专家学者，与阿里开源领军人和头部项目代表共同探讨开源领域的最佳实践和新机遇。本次开源开放周，在主论坛之外，还特设了 5 大分论坛，聚焦操作系统、数据库、云原生、大数据、终端 5 个领域，帮助开源人探索技术开放生态的更多可能。
在主论坛上，阿里巴巴开源委员会分管委员蒋江伟分享《阿里开源的动与势》，介绍了阿里巴巴开源的历史，分为使用、贡献、开拓三个阶段，阿里在创业早起就大量使用开源软件，阿里技术的发展也根植于开源的沃土中。当阿里在大规模互联网系统和云的研发中，积累了越来越多的技术经验，解决了越来越多的新问题之后，也积极地将自身的实践以开源软件的形态回馈到社区中。MongoDB 副总裁 Matt Asay 带来了《MongoDB 助力开发者实现高效开发》的分享，bilibili 技术委员会主席毛剑，也带来了《B 站在云原生与开源方向的探索与实践》的主题分享，并通过《数字世界已来，开源生态与未来》的圆桌讨论，邀请中国信息通信研究院云计算与大数据研究所副所长栗蔚，上海交通大学长聘教授、人工智能研究院总工程师、上海白玉兰开源开放研究院执行院长金耀辉，Apache 软件基金会首位华人董事、Tetrate 创始工程师吴晟，与阿里巴巴开源委员会秘书长、开源办公室负责人王晶昱共同展望了云与开源的更多可能。
另外五大分论坛也是干货满满，通过 2022 首届阿里巴巴开源开放周 Alibaba Open Source Week，阿里巴巴向业界分享了很多自身在开源中积累的实践经验，以及社区治理经验；同时，也通过自身链接了业内的技术专家及开源社区的负责人等，为开发者、开源爱好者们带来了极具价值和意义的内容。

### 9.3.3 百度

截至2021年底，百度已在GitHub主导的21个开源组织累计开源项目1000+个，社区贡献者达1.8万+，获得Star总数37万+。飞桨PaddlePaddle、Apollo、超级链等项目飞速发展；Apache Doris开启基金会毕业进程，HugeGraph项目启动捐赠Apache基金会孵化进程，并已获得投票通过。由于版面原因，我们在百度众多开源项目中选择部分代表性项目，分享他们的工作成绩。

重点开源贡献

飞桨(PaddlePaddle) ：目前，飞桨已凝聚406万开发者，基于飞桨开源深度学习平台创建47.6万个模型，服务15.7万家企事业单位。飞桨助力开发者快速实现AI想法，创新AI应用，作为基础平台支撑越来越多行业实现产业智能化升级。2021年飞桨框架发布了v2.0版本，正式进入了2.0时代，随后又完成了2.1和2.2两个版本的迭代更新。截至2021年12月31日，整体飞桨Family Star数累计109680(增长99%)，开源社区累计提交Commit超过50万次，以PR或Issue提交形式的开源贡献者超过了15000人。飞桨开发者技术专家(PPDE)累计180多位，飞桨开源合作伙伴计划已汇聚33个全球知名开源项目、8个国际开源组织/社区/基金会。飞桨领航团是面向所有深度学习技术爱好者的兴趣社区，目前已在全球建立200+社群。

阿波罗(Apollo) ：『Apollo开放平台』是一个开放的、完整的、安全的平台，旨在帮助汽车行业及自动驾驶领域的合作伙伴结合车辆和硬件系统，快速搭建一套属于自己的自动驾驶系统，目前已经升级迭代到第12个版本：Apollo 开放平台8.0。 Apollo开放平台8.0分别从“新架构”、“新能力”两个重要层面进行了全面升级，从开发者的实际需求出发进行改良，帮助开发者更好、更快地熟悉和使用百度Apollo开放平台—— 在平台架构层面上，从面向技术分层的架构，升级为结合技术与生态分层的架构，为开发者提供易用的软件核心和云服务工具及易扩展的硬件设备与软件场景应用；在平台能力构建上，通过软件包管理机制、感知全流程升级及全新PnC工具链，全面提升开发者使用效率。与此同时，全新上线的自动驾驶一站式学习实践社区——Apollo Studio，也成为开发者们一站式学习实践和共同交流成长的绝佳窗口。

作为全球最大自动驾驶开放平台，Apollo开放平台的开源代码量已超过75万行，并且汇聚了来自全球165个国家的10万多名开发者，拥有全球超220家生态合作伙伴，几乎囊括全球主流汽车制造商、一级零部件供应商、芯片公司、传感器公司、交通集成商、出行企业等，覆盖从硬件到软件的完整产业链。Apollo开放平台8.0的推出，再次让Apollo开放平台在工程易用性上向前迈进一大步，降低操作难度、操作成本的门槛，让更多开发者可以简单方便地上手Apollo开放平台、投身自动驾驶技术领域。

目前Apollo已获得中国测试牌照总计1018张，自动驾驶专利族超4800项，其中高级别自动驾驶专利族数全球第一，测试里程总计超过5700万多公里。Apollo开放平台始终秉“承开放能力、共享资源、加速创新、持续共赢”的核心理念，不断带来创新和升级。未来，Apollo也期待与更多开发者及合作伙伴一起，不断拓展能力边界、探索自动驾驶技术和产业的更多可能性，造福人类发展。

百度超级链(XuperChain) ：百度主导发起的开源区块链项目，全球开发者数量超过50000+。目前XuperChain在GitHub star数1550+，2021年新增Commit数560+、主版本迭代3次，新增仓库数12个。在关键区块链生态技术工具上，新增由外部企业贡献XuperIDE、XuperScan(浏览器)等技术工具。2021年全年组织40+场线上直播和线下沙龙，覆盖30000+开发者，社区面对来自100多家企业和高校的爱好者进行社区官方讲师认证，完成两套课程内容并出版一部教材，与20+家双一流高校达成区块链人才培养合作计划。在2021年内，XuperChain先后通过中国信通院功能和性能测试。

Apache ECharts ：是一个使用JavaScript实现的开源可视化库，可以流畅的运行在PC和移动设备上，兼容当前绝大部分浏览器，底层依赖矢量图形库ZRender，提供直观、交互丰富、可高度个性化定制的数据可视化图表。作为Apache软件基金会的顶级项目，目前Apache Echarts在GitHub Star数49k+，年增10%；Contributor有185人，年增26%，其中5人在2021年成为Committer，2021年内Apache ECharts共更新发布8个版本。

Apache Doris ：是由百度开源并贡献给Apache软件基金会的MPP分析型数据库产品，2021年作为Apache软件基金会的孵化项目，受到DorisDB影响，延缓了毕业进程。Apache Doris分布式架构非常简洁、易于运维，可以支持10PB以上的超大数据集。Apache Doris的GitHub Star从2021年初的2k增长到3.9k，一年间增加了95%。贡献者数量从年初的130增至234，贡献者规模和活跃度都有了极大的提升。与此同时，在2021年Doris社区还迎来了5位新晋PPMC以及7位Committer加入，分别来自美团、小米、京东等多家一线互联网公司。Apache Doris分别在2021年4月和11月发布了0.14和0.15版本。

### 9.3.4 腾讯
腾讯从创立之初就和开源结下不解之缘。23年前，公司的第一款产品QQ就运行在开源Linux服务器上。近几年，腾讯的开源工作主要围绕着项目开源、生态共建、社区治理三个方向推进。项目开源上，腾讯是GitHub全球企业开源贡献榜中TOP8的企业，开源了超过160个项目，累计获得了超过41万开发者的关注和Star。与此同时，腾讯持续贡献着超过30个主流开源社区，并加入了Linux基金会、Apache基金会等十余个国际开源基金会，也是开放原子开源基金会最早的发起单位之一。近三年，连续向Linux、Apache、开放原子开源、CNCF等多个基金会等捐赠了TARS、TSeer、Angel等7个开源项目，主导LinuxKVM、JDK等9个国际开源项目。
各技术领域的开源成绩
在操作系统领域，腾讯持续投入超过10年，与合作伙伴经过1000多万节点大规模场景验证的云原生操作系统OpenCloudOS，成为开放原子开源基金会开源项目的一员。
在云原生领域，腾讯2021年发布了多集群管理云原生管控平台Clusternet及云原生服务发现和治理中心Polaris Mesh(北极星)2个新项目。
在大数据领域，腾讯将进一步走向全面开源，并积极贡献和反哺开源社区，即将开源全场景在线离线混部解决方案Caelus和计算领域热门方向RSS(Remote Shufﬂe Service)的新项目Firestorm。
在数据库领域，腾讯将推出针对于大规模交易场景的企业级分布式MySQL内核数据库开源项目TXSQL。
在安全领域，腾讯2021年成为中国第一家加入OpenSSF安全开源基金会的企业，将引入腾讯安全二十年的安全能力沉淀，助力简化行业的开源安全流程，为开源项目的安全性提供保障。
在云成本领域，腾讯2021年加入FinOps基金会，作为国内首家FinOps基金会顶级会员，腾讯将联合FinOps基金会，全面推进对FinOps标准和最佳实践的贡献，为企业提供云财务管理的解决方案。
在多云异构领域，2021年腾讯作为首批创始企业加入Linux基金会旗下NextArch基金会(下一代架构基金会)。
生态共建
在生态共建方面，腾讯将两大核心技术版块——物联网操作系统TencentOS Tiny和企业级容器编排引擎TKEStack捐赠给了开放原子开源基金会，并即将捐赠第三个云原生操作系统项目。此外，全栈机器学习平台Angel、万亿级大数据消息中间件Apache Inlong(应龙)，高性能微服务治理框架TARS,云原生边缘容器开源项目SuperEdge等也陆续捐赠进入国际顶级基金会孵化和毕业。
从2006年开始，腾讯就围绕着人才培养、联合研究、学术交流三条主线，开展腾讯高校合作犀牛鸟计划，为行业培养优秀的互联网人才。2021年，腾讯首次启动了“犀牛鸟开源人才计划”，继续与高校深入合作，帮助学生由浅入深理解开源知识，用企业真实项目反哺教学，进一步助力开源人才生态的发展。首期计划中，一共有420所国内外高校，超过3000位学生参与。累计沉淀30+门开源精品课程进入校园课堂，学生满意度达92%。
社区治理
2021年，腾讯云建立了开放型开源社区——腾源会。2021年5月-2022年5月，腾源会累积举办各类社区活动50+场，覆盖10万+开源实践者、开源爱好者。
通过对“全球顶级开源项目社区治理”“开源领袖实践方法论”等不同维度的话题覆盖，链接了GoCN、Java China User Group等超过10个技术社区，超过70个开源项目社区，以及超过20个的开发者社区。
2022年上半年，腾源会也推出了“WeOpen Star开源摘星计划”与“WeOpen Good开源公益计划”。截至5月，“WeOpen Star开源摘星计划”吸引了1万+开发者关注，1000+人参与，70+开源项目加入，100+所高校联动，60+位专家辅导。“WeOpen Good开源公益计划”联动了真爱梦想、NGO2.0等公益组织，吸引30+公益案例方参与，20+位专家参与辅导和开源工作支持。
重点开源贡献
CloudBase Framework ：这是一款云原生一体化部署工具，持前后端应用一键部署，能够极大降低部署门槛、提升部署效率。
Nocalhost ：云原生开发环境工具，通过对开发空间、集群、应用、开发者和项目管理员的重新整合，可以做到训练环境的一键部署。
SuperEdge ：腾讯联合社区多家厂商共同发起的该云原生边缘容器通过捐赠评定，正式成为了CNCF云原生计算基金会的沙箱项目。
此外，在当前多媒体领域的主流开源项目中，腾讯都参与了贡献，比如媒体库(FFmpeg)、流媒体服务器(SRS)、编码库(AOM)、播放器(VLC)、传输协议(WebRTC、SRT)等。同时，腾讯也参与了音视频领域的多个开放标准组织，其中在Alliance for Open Media中，腾讯是国内唯一一家Founding Member，将来还会参与到下一代开放编码标准AV2的制定中。

### 9.3.5 中兴通讯
中兴通讯是Linux基金会旗下的LFN和LF AI &Data的创始成员以及最高级别会员，拥有两大基金会的董事会、TAC等席位；也是Open Infrastructure基金会(原Open Stack基金会)重要的黄金成员，中兴通讯在该基金会贡献颇多。在Train版本中Commit总数达到5000以上，位居全球第六；Ussuri版本中LoC45万行代码，位居全球第四；是国内最早参与Ceph社区的公司之一，在已发布的K~M三个版本中，贡献位居全球前三，中国第一；在LF AI&DATA基金会孵化推理侧工具链Adlik。
中兴通讯是首批参加OPNFV、OpenDaylight开源社区的电信网络设备厂商，是电信网络向虚拟化、容器化和智能化转型、标准与开源深度融合的践行者。2015年，中兴通讯以铂金会员加入OPNFV社区，是首批通过OVP(OPNFV Veriﬁed Program)认证的厂商。2016年，中兴通讯支持中国运营商在Linux基金会发起的网络自动化管理项目ONAP前身Open-O立项，为Open-O贡献超过50%的代码。2017年成为ONAP初创会员，并担任微服务总线MSB、告警分析Holmes两个子项目的PTL。2017年，中兴通讯以铂金会员加入OpenDaylight社区，将SDN协议的代码实现贡献到社区，共发起了6个新项目，并参与了社区80%的重要项目。2017年，中兴通讯以黄金会员加入CNCF，OpenPalette产品获CNCF社区Kubernetes一致性认证，获得社区KCSP认证。2018年，中兴通讯OPNFV开放实验室通过OVP Lab认证。2019年，中兴通讯首批参与GSMA和OPNFV联合发起CNTT项目，与主流运营商和设备厂商共同制订电信网络基础设施的模型、架构和测试规范。2020年，中兴通讯支持中国运营商在Linux网络基金会发起的5G/6G电信能力平台xGVela立项，并贡献TelcoPaaS初稿。大力推动5G网络切片、网络管理自动化、网络智能化等开源与标准在5G中的结合与应用。
2021年，中兴通讯以创始单位加入智能计算产业技术创新联合体(ONIA)，与行业伙伴共同推动开源神经网络处理器指令集架构NPU-IAS生态，成为ONIA的理事单位。中兴通讯继续在国际RISC-V基金会组织中发挥创始成员(现改为铂金会员)的作用，共同讨论处理器指令的开发，提出RISC-V在HPC领域的问题。在2021年，公司以高级会员身份加入了国内最大的RISC-V开源生态组织“北京开源芯片研究院”，与国内龙头企业(互联网、设备商、芯片设计方)、高校及研究所共同研究RISC-V开源生态建设和探讨后续工作规划。2021年底，中兴通讯GoldenDB产品线联合工行、招行、银联、网联、金电、华为、金融联盟共同发起MySQL金融分支开源社区，并进入MySQL金融分支的社区管理组(PMG)和技术管理组(TMG)。
重点开源贡献
Adlik ：由中兴通讯发起孵化，是LF AI&Data中首个聚焦深度学习模型推理阶段的项目，其宗旨是使深度学习模型能够高效地运行在多种部署环境下。利用Adlik，开发者可以方便地将主流训练框架如TensorFlow、Keras、Caffe、PyTorch等训练出的模型进行编译和优化，并根据模型部署的硬件环境自动选择优化的运行时环境，从而提升模型的推理效率，减少时延和能耗。
OpenDaylight ：是一套以社区为主导的开源框架，旨在推动创新实施以及软件定义网络(简称SDN)透明化。作为项目核心，OpenDaylight拥有一套模块化、可插拔且极为灵活的控制器，这使其能够被部署在任何支持Java的平台之上。这款控制器中还包含一套模块合集，能够执行需要快速完成的网络任务。从2015年开始，中兴通讯深度参与OpenDaylight开源贡献，先后六次立项，实现相关SDN控制器协议和技术，并担任这些项目的PTL。

### 9.3.6 中国联通
中国联通目前参与的开源社区主要涉及云计算、白盒交换机、白盒基站、网络编排器等领域，包括OpenInfra/OpenStack基金会(担任黄金会员董事)、Linux基金会(白银会员)、OpenEuler社区等。在Linux基金会白银会员基础上，中国联通作为白银会员/高级会员参加了LFN、SODA(担任董事)、CNCF子基金会。
自研海量数据存储项目YIG和AI算能服务平台CubeAI智立方已分别被LF SODA和OpenI启智社区接受为原生项目和孵化项目。其中，YIG实现中国联通在国际主流开源社区牵头项目“零”的突破。
加入欧拉社区，并在OpenStack SIG小组担任Maintainer。2021年11月，正式发布自主知识产权操作系统CULinux(China Unicom Linux)，结合轻量级虚拟化、高性能网络、安全容器等技术，可广泛应用于服务器、边缘计算、云基础设施等多种场景，支持多样性算力，适配X86和鲲鹏、飞腾等主流国产化算力底座。
重点开源贡献
YIG ：是一款可大规模横向扩展的云存储产品，YIG基于通用标准服务器，采用存储虚拟化技术构建统一的存储资源池，对外提供标准、兼容AWS S3协议的HTTP RESTful API接口。
CubeAI ：自主研发的集AI模型自动化服务封装、发布、共享、部署和能力开放等功能为一体的开源AI算能服务平台。平台基于CUBE-Net微服务框架进行开发，CUBE-Net微服务框架是中国联通自主研发的开源微服务应用基础开发平台和代码脚手架工具。

### 9.3.7 小米
2017年，小米在23个开源项目中保持活跃。其中，自研项目6个，主导项目3个，参与项目14个。这些项目中，大部分推出了Committer，总的Committer人数达50人。公司全年共为各类开源社区贡献patch数超3000个。同时，不断有新的项目申请开源，其中3个新项目在2021年内通过了开源评审后对外开源。
在开源人才贡献上，新增Apache Committer11人，其他项目Committer13人。在Hadoop、Hive、RocketMQ、Dubbo、TiDB等多个有影响力的开源项目上，小米首次推出Committer，实现突破。根据Apache软件基金会发布的2021年度报告，公司员工肖翔因为其在Apache NuttX项目上的突出贡献，荣登Top5Committers名单。此外，小米开源在2021年积极参加开源生态建设。
生态共建
5月，通过信通院“可信开源供应链”认证，成为国内首批通过可信开源供应链认证的终端厂商之一。
8月，小米Vela成功举办了国内首次NuttX开发组研讨会，多平台直播最高观看人数3000+，整个线上交流会讨论热烈，获得了很好的效果。
9月，机器人开源社区完成了开源风险评估，正式对外开源。不久，CyberDog项目通过信通院可信开源项目认证，成为信通院可信开源社区共同体的首批会员。
9月，举办Apache Pegasus首次Meetup。Meetup共计时长5小时，线下参加的人数达75+，线上B站和Datafun直播观看人数达800+。
10月，小米升级为Apache基金会的Targeted Sliver Sponsor。
同时，小米积极将自身的开源实践经验输出到外部，《开源项目与社区案例集》第一期收录了小米 MACE、Pegasus两个项目的开源实践案例，《企业开源治理案例集》第一期收集了小米公司的开源治理案例。公司全程参与筹备的中国计算机学会开源发展委员会在2021年12月正式成立。

### 9.3.8 滴滴
2021年，滴滴成为多家开源基金会、开源组织的首批会员，并积极在社区中发挥主导作用。截至2021年末，滴滴开源共有超过81个对外开源项目，其中9个新增对外开源项目。滴滴外部开源总Star数80k+，Fork数20k+，Issue数4k+，5k+公司及组织使用了滴滴开源项目，开源项目的开发者和用户超过2万人。滴滴内部开源项目新增118个，突破500大关，年度累计4k+人参与内源，累计产生161个社群，253个技术子项。
滴滴开源还涌现出一位ASF孵化器导师、一位Apache基金会顶级项目Pulsar的Committer。滴滴开源的消息与函数团队为Apache Pulsar项目持续贡献了49个PR，其中33个完成合并； 系统软件团队向Linux内核/OVS等社区贡献10个patch，参与多个patch的Review并给出改进建议；KV团队向RocksDB社区贡献4个PR完成合并；DT-计算平台为HDFS、Iceberg、ClickHouse、StarRocks、Pulsar、BookKeeper的等项目贡献56个patch。
生态共建
2021年3月，由中国开源软件推进联盟副秘书长、北京大学荆琦教授牵头组织，滴滴和北大软微学院联合开设的“开源软件开发基础及实践”课程通过了北京大学研究生院的新课申请，正式面向北大软微学院全体研究生开放授课。
2021年11月，滴滴开源参与Linux基金会旗下NextArch Foundation下一代架构基金会的筹建工作，成为首批共建和支持单位。同时齐楠作为企业代表成为TOC成员，参与探讨和制定基金会的发展路线工作。
2022年1月，Dokit、DELTA、LogicFlow、KnowStreaming等四个滴滴开源项目通过中国信通院评审，成为《可信开源社区》共同体成员。
重点开源贡献
DoKit ：目前在GitHub上的Star数已经突破18000，已累计14000+终端App接入使用。
LogicFlow ：2021年在npm发布了90+小版本，并于2021年12月31日发布1.0版本。目前已有较多公司在实际项目中接入使用，LogicFlow平均npm周下载量40k+、GitHub Star 2k、收到GitHub Issue 200+。
Know Streaming ：Know Streaming基于Apache 2.0协议进行分发和开源，未来考虑捐赠给国内开源组织，为中间件类基础软件运维管控做一点自己的贡献。

### 9.3.9 微众银行
微众银行坚持不懈地探索和实践开源，提升企业自身的技术水平和能力，基于开源软件建立了安全可控的银行核心系统，同时，建立了完善的开源治理体系，防范合规及安全风险。在贡献开源，将技术实践回馈社会方面，致力成为优秀的开源组织。经过多年的努力，截止2023年5月已有33个项目对外开源，包括人工智能、区块链、云计算、大数据和前端等多个领域，并建立了具备较大影响力的开源项目社区，获得了来自全球开发者的超过 3.7万的Star 和1.4万的Fork。主要领域及代表项目： 
AI领域,FATE（Federated AI Technology Enabler）是微众银行人工智能团队自主研发的联邦学习工业级开源框架，截止2022年已有工商银行、中国银联、VMware等19家成员单位，覆盖全球超过1,200家知名企业与500家高校、研究机构，成为联邦学习领域有较大影响力的开源社区。	 
区块链领域，截至2022年末，FISCO BCOS已入驻9个国家级基础设施，超过300个标杆应用在生产环境中稳定运行。2022年，在国际标准化组织区块链和分布式记账技术委员会 （ISO/TC 307）年内发布的区块链领域国际标准化成果《区块链与分布式账本技术 用例》中，50%的中国用例系基于FISCO BCOS研发。凭借在构建开源联盟链生态圈方面的突出贡献广泛获得权威认可，在2022年及2023年连续两年入选《福布斯》“全球区块链50强”。
云计算领域，EventMesh项目作为微众银行开源路线的战略核心产品，2021年微众银行将EventMesh项目捐献到Apache 国际软件基金会进行孵化，2022年项目被CNCF Landscape收录，同时发布了全球首个遵守CNCF Serverless workflow标准的go-engine实现，在Serverless领域引起广泛关注。项目于2023年初成功从Apache基金会孵化器毕业成为顶级项目。
大数据领域，微众银行开源的一站式、金融级开源大数据平台套件WeDataSphere，填补了业界 “开源体系化大数据平台套件”的空白，受到了各行业的广泛欢迎和采用。2022年项目集发版超过60次，社区吸引了超8000位开发者参与，收到超过100家企业应用生产反馈，数据量超400PB，有250余位企业开发者参与贡献，涉及金融、互联网、通信、制造、教育等众多行业，逐步形成了高度活跃且有广泛影响力的大数据平台开源社区。2022年，社区荣获了深圳市金融创新奖项，并且，由微众银行主导和发起的大数据计算中间件项目Linkis成功成为Apache基金会的顶级项目，标志着全球第一个由银行发起并成功毕业的Apache顶级项目的诞生。
微众银行基于开源项目，持续拥抱开源社区和开源基金会，精耕开源治理的同时与合作伙伴及社区用户共同建立开源生态圈，为推动国内科技创新和提升中国基础软件国际影响力贡献力量。
 

### 9.3.10 浪潮软件
浪潮产品当前使用的国际开源软件超过900余个，涉及40余种开源协议，参与200余个开源项目的社区贡献，覆盖云计算基础设施、云原生基础设施、工业互联网、分布式数据库、区块链等多个技术领域。
公司先后加入OpenStack、Linux、Apache、SPEC、TPC等国际权威组织，以及全球三大开放计算标准组织，并成为ODCC供应商会员、OCP铂金会员和OPEN19首批成员。浪潮是木兰开源社区首批贡献者和社区建设的践行者，同时作为创始会员共同筹建了中国首个、也是目前唯一一个以开源为主题的基金会——OpenAtom开放原子开源基金会，作为副理事长单位参与到社区建设中。
推动近百人参与OpenStack社区贡献。在社区即将发布的Yoga版本中，代码提交量(Commit)、完成蓝图数量(Completed Blueprint)、补丁集数量(Patch Set)、贡献代码行数(LOC)等方面均为中国第一。
公司向OpenStack国际开源社区贡献首个智能运维领域开源项目VENUS并完成孵化，顺利成为官方项目；云海OS团队聚焦Nova、Cinder、Cyborg、Manila等核心项目，实现对异构加速器设备虚拟机的支持并完善虚拟机重建和疏散、搁置和取消搁置等功能；新增任意时间节点的卷快照回滚、Inspur SSD、FPGA设备驱动、文件存储回收站等功能，并在智能加速设备管理Cyborg、可视化日志管理Venus、云数融合Sahara和高可用管理Masakari等主流项目新增PTL(开源项目负责人)4名，Core Reviewer十数名，社区全球贡献排名全球前五，国内第一。
社区贡献
CNCF社区 ：自2017年开始，在声明式集群管理、多容器运行时、多容器网络、多容器存储、镜像加速、网络加速、主备容灾等方面重点技术研发，并持续回馈社区，累计提交贡献4000+。基于CNCFCKAD认证体系和Kubernetes项目的实践经验，已开展云原生系列课程培训20余次。通过CNCF Kubernetes X86和ARM双一致性认证，为社区贡献首个MIPS架构Kubernetes一致性测试方案。
OpenAtom社区 ：围绕低代码、工业互联网、云原生等技术领域，参与ApereCAS Server、Helm、Bitnami、SEATA等开源项目贡献。已将UBML低代码平台项目(工业互联网方向)和云溪数据库(云原生分布式数据库方向)两个项目捐赠给开放原子开源基金会，成为基金会旗下的孵化项目。
木兰社区 ：贡献云操作系统控制台OpenSkyline项目到木兰开源社区，通过TOC评审顺利进入木兰开源社区开源项目孵化池。基于Gitee、GitHub、Trusite多库托管，实现各平台项目代码相互备份，成功发布第一个正式版本。
2021年，公司正式发布“源1.0”开源开放计划，模型参数规模为2457亿，训练采用的中文数据集达5000GB，相比GPT-3模型的1750亿参数量和570GB训练数据集，参数规模领先40%。
重点开源贡献
UBML ：定位于工业互联网平台架构中的aPaaS层。具有微内核可扩展开放架构、全栈业务建模、开发语言无关性、模型工程化、模型全生命周期管理、同时支持解析型+生成型的Hybrid模式等特点。
云溪数据库 ：自主研发的云原生分布式数据库，采用分布式架构设计开发。提供数据库原生自动部署、自动备份、自动容灾、数据恢复、监控等全套解决方案，可支撑单表过亿的海量数据事务交易 场景。

### 9.3.11 京东
京东对外开源了前端、云计算、人工智能、区块链、联邦学习等一系列项目。2018年将分布式文件系统和对象存储系统ChubaoFS项目捐献给CNCF基金会，并于2020年进入沙箱。
京东紧密保持与国内外开源基金会与组织的联动，不仅是CNCF会员、OpenEuler会员，还加入了中国信通院云计算标准和开源推进委员会、科技制造开源技术应用社区，并且也是开放原子开源基金会的初始会员之一。

### 9.3.12 字节跳动
字节跳动积极投入开源社区建设。从2015年Rcproxy项目开始，字节跳动陆续对外开放多个经过内部业务验证的开源项目，包括现代Web开发框架Modern.js、微服务中间件CloudWeGo、高性能分布式训练框架BytePS、联邦学习平台Fedlearner、训练加速引擎LightSeq、Flutter应用内调试工具UME等。
目前，字节跳动已经对外开源五十多个项目，分布应用在前端、客户端、后端、AI/算法等领域。

##9.4 中国原生开源企业加速涌现

### 9.4.1 麒麟软件
2014年，麒麟软件(前身为中标软件)成为开源社核心初创成员，2016年成为Linux基金会正式成员，2019年在开源OpenStack正式项目中获得1个项目的领导者(PTL)席位，2021年成为可信开源社区共同体正式成员。
社区贡献上，麒麟软件是Linux、Ubuntu、Debian、Ubuntu Kylin、UKUI、OpenStack、OpenEuler、GNOME、Unity、Ceph、Ovirt等知名开源组织和项目的重要贡献者与维护者。由公司发起的开源项目UbuntuKylin开源桌面操作系统累计安装量(仅官网下载统计)超3800万、UKUI桌面环境进入多数主流Linux发行版软件仓库。
公司热衷于开源布道，为埃塞俄比亚、加纳、赞比亚等7个国家提供开源操作系统培训服务，并累计在全球30多个城市的50多所大学里举行了版本发布会、麒麟杯软件大赛、开发者大会、Linux应用沙龙、生态软件测试、KMRE体验等超过100场的线下活动，让开源操作系统真正走进多所高校的教学课堂和课程实践，培养出Linux人才数万人。
重点开源项目
UKUI ：是一款基于Linux系统可插入框架的轻量级桌面环境。基于Qt进行开发，用于浏览、搜索和管理计算机。截至2022年2月，UKUI项目Issue超过4600，Pull Request超过3000，Commit超过17100，Contributor共246人。
优麒麟(Ubuntu Kylin) ：是一款通用桌面电脑操作系统，自2013年以来已发行19个正式版本，全球累计安装量超3800万次，社区爱好者数十万，社区贡献者数百位。截至2022年2月，Ubuntu Kylin项目Issue超过780，Pull Request超过650，Commit超过5290，现有5个SIG。
社区贡献
Kernel.org社区 ：麒麟软件向Linux Kernel所做贡献覆盖Ceph、xor、raid、io_uring、net等。在全球参与内核贡献的近900家企业中，贡献排名居244位，在国内贡献企业中排名第12位，累计Submit(Patch)104个。
OpenStack社区 ：截至2022年2月，麒麟软件向OpenStack社区累计Submit(Patch)5500+，修复Bug 1600+，完成蓝图40+，贡献代码10万行。
openEuler社区 ：公司共有155人直接参与openEuler社区，其中2人为TC，24人为Maintainer。截至2022年2月，累计提交Issue 1300+，Pull Request 2000+，维护项目300+，参与代码类项目50+，发起6个SIG，在5个SIG中担任Maintainer。

### 9.4.2 统信软件
统信软件基于Linux内核自主研发并开源了DDE桌面环境以及系列应用软件，已被主流Linux发行版所采纳。在国际主流社区(Ubuntu、Debian、CentOS等)贡献组件数量超过70多个。参与上游Linux Foundation内核社区开源贡献，在操作系统核心组件如kernel、gcc、binutils、glibc、cmake、elfutils、libtool、clang、boost、gdb等领域，统信软件适配集成补丁超过5000个。自研并反馈上游社区补丁超过500个，其中被上游社区采纳数量超过400个。
作为全球Linux最重要的发行版之一，统信操作系统社区版deepin全球累计下载量超8000万次，全球社区用户超过200万。自加入Qt社区，2020年代码贡献排名第五；2021年代码贡献度排名第三。
社区贡献
统信开源社区(deepin) ：用户遍布全球100多个国家与地区，累计发布版本40余次，支持语言34种，累计下载量超过8000万次，全球社区用户超过200万，提供开源代码超过600万行。拥有6个海外社区，在40多个国家拥有130多个镜像站点，可为中国操作系统提供国际开源社区支撑。
openEuler ：统信软件服务器研发负责人担任openEuler社区TC委员，6个SIG组maintainer由统信软件研发专家担任，累计申报TC议题9次，提交Issue100+，提交PR239个，参与社区SIG例会113次，积极活跃于社区29个SIG组(例如：Kernel、虚拟化、容器、Release、QA等重要SIG)。已为社区提交Pull Request 900+，Issue 900+，举办SIG Meeting 100+。贡献自主研发的桌面项目58个，在openEuler 21.09创新版本完成DDE大版本迭代一次，并引入了自研的桌面影音软件。
OpenAnolis ：统信软件是OpenAnolis(龙蜥)社区理事单位，在OpenAnolis社区的贡献或参与情况包括：提供DDE桌面及其相关的系列桌面应用；提供arm编译构造与集成环境，并进行部分社区基础设施维护；提供社区版本ISO集成构造技术支持，参与社区的版本构建与发布；构建社区版本的容器镜像并提供容器的构造文档；参与社区版本的测试与测试报告输出；参与社区代码提交审核等。截至2021年7月底，完成社区代码仓库同步3600+，koji提交3900+，Commit提交220+，Bug提交30+，Bug修复70+，以及部分社区技术文档编写；参与维护的社区SIG组包括Cloud Kernel、DDE、跟踪诊断技术、高性能存储、全栈国密、Java语言与虚拟机、LoongArch、Distro、基础设施、QA；轮值参与社区社群内开源用户问题反馈沟通与技术交流。
上游贡献(Ubuntu、Debian、CentOS等) ：自主研发开源DDE桌面环境及系列应用软件，已被主流Linux发行版所采纳。在国际主流社区(Ubuntu、Debian、CentOS等)贡献组件数量超过70多个。在核心组件如Kernel、Gcc、Binutils、Glibc、Cmake、Elfutils、Libtool、Clang、Boost、Gdb等领域，统信操作系统适配集成补丁超过5000个。

### 9.4.3 平凯星辰

平凯星辰（PingCAP）是一家企业级开源软件服务供应商，其创立的企业级开源分布数据库 TiDB，为关键业务打造，具备分布式强一致性事务、在线弹性水平扩展、故障自恢复的高可用、跨数据中心多活等核心特性。TiDB 是全球知名的开源项目，目前在 GitHub 上已总计获得超过 34.1k 颗星，累计超过 1714 位开源贡献者，项目已经合并的 Pull request 数 28151 个，已经解决的 Issue 数 11807 个。TiDB 项目来自 PingCAP 以外的社区贡献者（Contributor）占比 75% 以上，吸引了腾讯云、韩国三星研究院等企业和机构的优秀开发者共同参与。

TiDB 社区是由 TiDB 生态中的开发者、用户、合作伙伴一起建立的分享、学习平台。TiDB 线上社区汇聚了 29149   位 TiDB 资深用户（注册用户数），所有成员都可以在这里自由发声，互相协助解决问题。社区线上论坛 asktug.com 已经积累了 19799 个问题帖（主题帖数），90% 的问题都得到了解决，累计总回复数 126359个（主题帖回复数）。2022 年 12 月，TiDB 社区荣获 CSDN 评选的 2022 中国开发者影响力年度榜单“年度开发者社区”奖项。

经过八年多的持续运营，TiDB 开源社区已成为全球数据库领域活跃度领先的开源社区。目前，TiDB 开源社区已覆盖全球 45 个国家和地区，拥有 2051 位外部代码贡献者，并在中国十多个城市，以及美国、欧洲、日本、新加坡等地定期开展线上、线下社区活动，保持了社区的活跃度和生命力。TiDB 的技术文档已被社区参与者翻译成日语、俄语、西班牙语和葡萄牙语等，极大推动了产品的全球化。

在开源生态建设方面，随着 TiDB 的生态不断发展，有大量的上下游生态项目在社区中涌现。TiDB 社区 为这些项目提供了孵化器机制，帮助他们获取更多资源和帮助，能够快速成长达到有实际应用场景的成熟阶段。由知乎发起的 incubator 项目 TiBigData 旨在解决企业大数据场景中各项技术栈对接 TiDB 的整合问题，目前已提供 TiDB 与 Flink 和 Presto 的整合能力，并已应用在知乎的数据集成平台和 OLAP 分析场景中。TiDB for PostgreSQL 项目由神州数码发起，旨在提供 TiDB 对 PostgreSQL 的兼容性，同时保留了 TiDB 的高可用性、弹性和可扩展性，允许用户将现有的 PostgreSQL 客户端连接到 TiDB，并使用 PostgreSQL 特有的语法。ServerlessDB for HTAP 项目是要把云数据库服务变成黑盒子，让应用开发者只需要专注于业务如何转化成 SQL，再也不用操心数据量、业务负载等和业务不相关的事情。

TiDB 社区运营活动非常丰富，定期举办 Infra Meetup、TiDB User Group 企业行、Hacking Camp、Paper Reading、性能竞赛等社区活动。TiDB Hackathon 是 TiDB 社区创办的全球顶级赛事，参赛队伍需在规定时间内围绕整个 TiDB 生态做出一个完整的作品。TiDB Hackathon 已成功举办六届，2022 年共有 303 名选手报名 ，86 支队伍参赛，产生了系列富有创意兼具应用价值的作品。2022 年 12 月，在 SegmentFault 评选的 2022 中国技术先锋年度榜单中，TiDB Hackathon 2022 荣获“最受开发者欢迎的技术活动”奖项。

对中国开源生态发展的观点与建议
第一，加强开源人才培养，积极推广开源文化。培养和留住开源人才是发展开源产业的关键。建议教育、人社、科协等部门，推动高校开设开源课程，支持国内开源项目和技术进入高校课程，支持企业参与高校教学实践，例如面向学生开展开源科普活动，推广开源文化等，全方位完善开源人才教育体系。

第二，扶持开源企业发展，培育优秀开源项目。从开源产品的诞生到商业化，往往要经过很长的周期。建议政府部门对开源项目、开源产品和开源企业给与更多的耐心和更长期的支持。例如，鼓励各行业企业积极拥抱开源，出台相关支持政策，引导企业采用开源产品，扩大开源用户群体等。

第三，鼓励开源企业国际化，积极参与全球竞争。数字经济快速发展，中国的规模化场景有机会诞生世界级的基础软件公司。开源能吸引全球人才、汇聚全球场景、快速打磨产品，在技术变革日新月异的今天，为中国企业超越传统巨头提供了可能。借助开源“全球化”的天然属性，中国基础软件公司有能力参与全球竞争，建议政府鼓励更多的中国开源企业走向世界，并提供相应的政策支持。

### 9.4.4 易捷行云
易捷行云EasyStack(北京易捷思达科技发展有限公司)成立于2014年，是中立的企业级云计算产品与服务提供商。易捷行云EasyStack深耕开源生态产品化，率先实践开源基础设施标准LOKI(Linux OpenStack Kubernetes Infrastructure)。在Linux方面，公司是Linux基金会会员、开放原子开源基金会openEuler社区成员、龙蜥社区会员；在OpenStack方面，公司是OIF黄金会员和创始成员，连续两年成为拥有OIF黄金会员董事和个人独立董事的“双董事”席位的唯一中国企业；在Kubernetes方面，公司是CNCF和OCI容器基金会会员；在基础设施方面，公司是Ceph基金会创始会员。
易捷行云EasyStack积极参与开源社区并贡献核心代码，多次在OpenStack、Ceph、Kubernetes核心代码贡献中名列全球TOP10。此外，公司是开放原子开源基金会捐赠人，参与发起“科创中国”开源创新联合体并成为联合体理事单位。
开源社区建设
易捷行云EasyStack鼓励全员参与工作相关的各类开源社区，包括OpenStack、Kubernetes、Ceph、openEuler、龙蜥等社区，在多个社区获取重要的角色，包括Kubernetes、OpenStack等多个项目的核心评审员。
OpenStack ：在Nova、Cinder、Neutron、Keystone等核心项目贡献排名Top 5，总计贡献Commits数318，修复Bug数8个，贡献代码量12000+行，工作超过1000人天，KataContianer核心贡献者1人，主导国内、东南亚等区域活动，提升社区影响力。
Ceph ：Ceph社区贡献次数119次，代码量6000+行，核心Committer 1名，作为赞助商协助推动开源社区透明性建设，推进社区规划及财务公示，官方网站关注运营模型介绍等信息。
CNCF ：CNCF社区投入Kubernetes、containerd、etcd、kube_OVN等多个项目，其中社区多个版本国内贡献TOP10，贡献核心需求10+，修复Bug数十个，是社区赞助商之一。
公司融资情况

表32 易捷行云融资情况

### 9.4.5 涛思数据
采用 AGPL 许可证，涛思数据已经将 TDengine 的内核(存储、计算引擎和集群）100% 在 GitHub 开源，并尽最大努力打造开发者社区，旨在通过开源，快速获得市场反馈，完善产品和生态，吸引更多的开发者加入到项目中。发展 3 年时间后，TDengine 在 GitHub 上的 Star 数已经达到了 21.3k，全球运行的 TDengine 实例数超过 248.9k，多次登顶 GitHub 全球趋势排行榜。
TDengine 项目十分活跃，从 2019 年开源到 2023 年，其已成长为时序数据库领域 Star 数排名第三的新星项目，并在全部开源数据库产品中，位居第六；同时，保持着在开源时序数据库领域中最快的 PR 增长速度，截止到 2023 年 1 月 16 日，Pull Request 总次数已经达到 15.8k。
2022 年 8 月 TDengine 3.0 成功发布，成为了一款云原生时序数据库，解决了业内的 High Cardinality 问题，能支持 10 亿条以上的时间线，100 个节点以上的集群。它在分布式设计的基础上，实现了计算和存储分离，重构了流计算、数据订阅功能，升级了查询引擎、存储引擎，产品性能获得了质的升级。


### 9.4.6 白鲸开源
白鲸开源主导2个Apache项目：Apache Dolphinscheduler和Apache SeaTunnel。
Apache DolphinScheduler是一个云原生的分布式大数据工作流调度平台。全球唯一采用无中心化架构设计的分布式调度系统，这也是首个由国人主导并贡献到 Apache 基金会的大数据工作流领域的顶级项目。已累计有3000+海内外公司在生产上使用。目前 DolphinScheduler Docker 版本下载量已突破500万次，Star过万，Fork 3800+，issue数6500+，PR数7000+，连续2年获得InfoQ中国技术力量年度榜单 "十大开源新锐项目"。
Apache SeaTunnel是新一代超高性能的数据集成工具，支持过百种数据源之间的数据高效同步与转换。于 2021 年底加入 Apache 孵化器，近期也即将毕业成为顶级项目的工具。已经有数百家公司在生产上使用，广泛适用于互联网、金融、制造、零售、工业等各个行业,开源中国评选获“2022年度优秀开源技术团队”称号。

在2022年6月至2023年5月期间，白鲸开源科技取得了以下重点进展与成果：
1. Apache SeaTunnel版本升级与新增功能：白鲸开源科技在该时期发布了多个Apache SeaTunnel的版本，包括新增了自研高性能同步引擎Zeta，并计划发布2.3.2版本。这些版本升级和新增功能提升了SeaTunnel的性能和功能，进一步提高了数据源之间的高效同步与转换能力。
2. Apache SeaTunnel贡献者增加：白鲸开源科技在该时期新增了130多位贡献者，这些贡献者积极参与SeaTunnel项目的开发和贡献，为项目的改进和发展做出了重要贡献。
3. Apache DolphinScheduler多个版本发布：白鲸开源科技在2022年6月至2023年5月期间发布了近10个Apache DolphinScheduler的版本。这些版本的发布带来了新的功能、修复了漏洞，并吸引了200多位贡献者的参与，进一步完善了DolphinScheduler作为云原生的分布式大数据工作流调度平台的能力。
4. 开源推广与活动：白鲸开源科技在该时期继续举办了多场线上线下的Meetup活动，提供了交流和分享的平台。他们还在北京、成都、杭州等地举办了线下活动，并计划在上海和深圳举办。这些活动促进了开发者之间的交流和合作，扩大了开源项目的影响力。
5. 与上下游生态项目的集成：白鲸开源科技进一步加强了与Flink、Spark、TiDB、OceanBase、IoTDB等众多上下游生态开源项目的集成。这些集成工作促进了不同项目之间的协同发展，提升了整个开源生态的互操作性和整体性能。
通过以上的重点进展与成果，白鲸开源科技在2022年6月至2023年5月期间取得了在SeaTunnel和DolphinScheduler项目中的版本升级与功能增强，吸引了更多的贡献者参与，举办了多场开源推广与活动，并加强了与其他开源项目的集成。这些进展和成果推动了白鲸开源科技的项目发展，并为整个开源社区做出了贡献。

社区获奖情况：
CSDN 2022开发者生态汇暨IT技术影响力之星获「年度开源项目」奖项
Apache DolphinScheduler PMC Member, Apache SeaTunnel Mentor 郭炜获「年度IT领军人物」
中国开源云联盟优秀项目评选，Apache SeaTunnel 获「优秀开源项目奖项」
思否 2022 中国技术先锋年度评选 Apache SeaTunnel获「尖峰案例」奖项
2022 InfoQ 中国技术力量年度评选 Apache DolphinScheduler 获「十大开源锐新项目」，连续 2 年获得此殊荣
2022 年度OSC 中国开源项目评选 Apache DolphinScheduler 和 Apache SeaTunnel 均获「优秀开源技术团队」奖项
2022 年度 OSC 中国开源项目评选 Apache SeaTunnel 获「中国开源社区健康案例」奖项
2022 中国开源创新大赛 Apache DolphinScheduler 获「二等奖」奖项

白鲸开源公司获奖情况：
掘金引力榜 白鲸开源获评「年度新锐企业Top10」
白鲸开源联合创始人；Apache DolphinScheduler PMC Chair & Apache SeaTunnel PPMC & Mentor 代立冬获「OSCAR开源尖峰人物」奖项
2023 全球人工智能开发者先锋大会开源项目路演 白鲸开源获「优胜奖」
2023 科创中国开源创新榜 白鲸开源入选”10 大“开源机构”榜单
2023 爱分析 DataOps 厂商全景报告 白鲸开源入选全景图

开源社区发展与治理：
白鲸开源科技在开源社区发展与治理方面采取了以下措施：
1. 公开透明的治理机制：白鲸开源科技遵循Apache基金会的要求，建立了公开透明的社区治理机制。社区成员可以通过邮件沟通、社区讨论等方式参与决策和讨论，确保社区治理的公平和公正。
2. 社区规范和指南：白鲸开源科技制定了社区规范和指南，明确了社区成员的行为准则和开发流程。这些规范和指南有助于维护社区的秩序和稳定性，促进社区成员之间的合作和协作。
3. 社区成员培养与支持：白鲸开源科技注重培养和支持社区成员的发展。他们提供了培训和教育资源，帮助新加入的开发者了解项目和社区的工作方式。同时，他们也鼓励社区成员互相学习和分享经验，提高技术和管理能力。
4. 社区活动和交流：白鲸开源科技举办了线上线下的Meetup活动，为社区成员提供了交流和分享的平台。这些活动促进了社区成员之间的互动和合作，加强了社区的凝聚力和活力。
通过以上的发展与治理措施，白鲸开源科技努力维护开源社区的健康发展，确保社区成员的参与和贡献。他们注重公开透明的社区治理，建立规范和指南，培养和支持社区成员，并通过活动和交流促进社区的发展和交流。这些举措有助于推动开源社区的繁荣和创新。

开源推广与活动方面：
我们已经举办线上线下 Meetup 10+ 场，平均每个月 1、2 次，今年已经在北京、成都、杭州等地举办线下活动，上海和深圳也即将举办。

白鲸开源科技在开源推广与活动方面采取了以下举措：
1. 组织线上线下Meetup活动：白鲸开源科技定期组织线上线下的Meetup活动，为开发者和开源爱好者提供一个交流和分享的平台。这些活动涵盖了各种主题，包括技术分享、项目介绍、最佳实践等，吸引了广大开发者的关注和参与。
2. 参与国内外的技术大会和展览：白鲸开源科技积极参与国内外的技术大会和展览，展示他们的开源项目和技术成果。通过与业界专家和开发者的交流，扩大了开源项目的影响力和知名度。
3. 社区合作与交流：白鲸开源科技与其他开源社区和组织进行合作和交流，共同推动开源技术的发展和应用。他们与其他开源项目合作，共同解决技术难题，提升开源生态的整体水平。
通过以上的推广与活动举措，白鲸开源科技积极推动开源技术的传播和应用。他们通过举办活动、培训和参与展览等方式，为开发者和企业提供了学习和交流的机会，促进了开源技术的普及和应用。同时，他们与其他开源社区的合作和交流，进一步拓展了开源生态的边界，推动了整个开源社区的共同发展。

开源生态共建贡献方面：
白鲸开源科技在开源生态共建方面做出了以下贡献：
1. 与上下游生态项目的集成：白鲸开源科技与众多上下游开源项目如Flink、Spark、TiDB、OceanBase、IoTDB等进行了集成，通过互相支持和合作，促进了整个开源生态的发展和互联互通。
2. 参与社区贡献：白鲸开源科技的开发者和团队成员积极参与各个开源社区，并贡献代码、修复漏洞、提出建议等。他们通过提交Pull Request、解决Issue等方式，为开源项目的改进和完善做出了贡献。
3. 推广开源文化：白鲸开源科技举办了多场线上线下的Meetup活动，旨在推广开源文化，促进开发者之间的交流和合作。这些活动为开源社区的发展提供了一个平台，激发了更多人参与开源项目并做出贡献。
通过以上的共建贡献，白鲸开源科技积极推动了开源生态的发展，与其他开源项目形成了良好的协同效应，共同推进了开源技术的创新和应用。

代表性开源人物贡献：
代表性开源人物代立冬在Apache DolphinScheduler项目中担任项目管理委员会主席，并从项目孵化开始一直积极参与社区贡献。他不仅在技术上做出了贡献，还倡导开源共建的理念，推动社区成员的参与和贡献。

对中国开源生态发展的观点与建议:
中国开源生态在过去几年取得了显著的发展，许多国内开源项目在国际上也获得了广泛的认可和使用。白鲸开源科技在其中发挥了积极的作用，并取得了一些重要成果。以下是对中国开源生态发展的观点和建议：
1. 加强开源文化建设：在中国，开源文化的传播和普及仍然需要进一步加强。需要鼓励更多的开发者和企业参与到开源项目中，促进知识共享和协作。同时，也需要提高对开源的认知和理解，推动开源在教育、企业和政府等领域的广泛应用。
2. 提高开源项目的质量和影响力：中国的开源项目在数量上已经有了一定的积累，但在质量和影响力上仍有提升的空间。需要注重项目的技术创新和实用性，鼓励更多的高质量项目涌现。同时，要积极参与国际开源社区，与国际项目进行合作和交流，提高项目的知名度和影响力。
3. 加强开源社区建设和治理：开源社区是开源项目成功的关键所在。需要建立健全的社区治理机制，促进社区成员的参与和贡献。同时，要提供良好的沟通和协作平台，鼓励开发者之间的交流和合作。此外，还需要加强对社区成员的培训和支持，提高其技术和管理能力。
4. 加强开源与产业的结合：开源技术在推动产业创新和发展方面具有重要作用。需要加强开源技术与各个行业的结合，推动开源技术在企业和公共服务领域的应用。同时，要积极培育开源技术生态圈，促进开源项目和产业链的协同发展。
中国开源生态已经取得了一些成绩，但还有很多工作需要继续努力。通过加强开源文化建设、提高项目质量和影响力、加强社区建设和治理以及加强开源与产业的结合，可以进一步推动中国开源生态的发展，促进技术创新和产业升级。

### 9.4.7 思斐软件
北京思斐软件技术有限公司(SphereEx)于2021年4月，由Apache顶级开源项目ShardingSphere核心团队创立。2021年5月获得数百万美元天使投资，2022年1月获得近千万美元Pre-A轮融资。
SphereEx曾在Google Summer of Code、西雅图创业协会、Stack Overflow等多个组织分享开源技术与创业经验。累计在全球参与包括PGConf.Asia、COSCon、ApacheCon、OpenSource Day、Grace Hopper Celebration等在内的50多次海内外线上、线下活动。
重点开源贡献
2022 年 SphereEx 支持并推动 ShardingSphere 项目更新迭代 8 个版本，累计收获 GitHub Star 18.3k，贡献者人数从 2021 年的 260 一跃超过了 500 人，累计提交 PR 超过 1.6k 。在 2022 年 GitHub 所有中国开源项目的数据指标中，Apache ShardingSphere 位居第三。在捐献给基金会里的中国项目排行榜中，ShardingSphere 荣登榜首！为了满足更多用户在云方面的诉求， 2022 年 9 月 8 日  ShardingSphere 推出 ShardingSphere 云上解决方案 ShardingSphere-on-Cloud，并正式开源，开启 Database Plus 的云上之旅。
社区的内容矩阵：2022 年 ShardingSphere 的案例被 MySQL 官网的收录，“The Next Evolution of the Database Sharding Architecture” 相继发布在 InfoQ 英文站、日文站、中文站主页，并得到了海外多家技术网站的转载，入驻 StackOverflow，并受邀 The Overflow 博客接受的采访，ShardingSphere 产品和文档登录 Grafana Labs 。
学术贡献：2022 年，SphereEx 宣布与重庆大学展开合作；在 IEEE 的数据库顶级会议 ICDE 上发布了前沿思想理念，并向全球数据库专家解读了 ShardingSphere。时隔四个月，Apache 核心贡献者撰写了第一本全面介绍 ShardingSphere 并演示了几个设计细节和最佳实践的《Apache ShardingSphere 权威指南》并在亚马逊，并在亚马逊、O'Reilly、Barnes & Noble、 Packt Global;、Google Books 等 180+ 国家上线发售。
开源布道：社区定期举办 Meetup ，邀请业内大咖和社区专家深度探讨数据架构的发展分享经验和实践，截至目前累计主办联合主办活动数十场。除了ShardingSphere 主导的技术活动，SphereEx 也积极参与合作伙伴和行业的活动，这一年，SphereEx 推动ShardingSphere 出席并参与包含 DTCC、OpenSource Day、Google Summer of Code、FOSDEM、FOSS、J-CON Java International Conference、UXDX  等近百场知名海外技术盛会。

##9.5 国际机构、国际企业对中国开源的贡献
通过本章前文所述，我们可以看到中国在开源贡献上令人欣喜的进展，短时间内从使用开源到积极贡献。但在目前的开源贡献者索引网站中，活跃贡献者排名前十依然是国际企业。因而，国际机构和企业的开源实践，以及对中国的开源贡献将进一步推动中国开源的发展。
为此，我们以Apache基金会、Linux基金会、IBM、Intel、微软、红帽等机构和企业为例，介绍国际通行的开源之道，以及对中国开源的贡献，希望可以对中国的开源发展有所启发。

### 9.5.1 Apache对中国开源的贡献
2012年之前，国内与ASF(Apache Software Foundation，简称“ASF”)接触的公司主要集中在外企，例如Intel中国研发中心、IBM中国研究院、eBay中国等。但在2012年之后，华为、阿里巴巴、百度、京东、腾讯等公司开始陆续将项目捐赠给ASF，在ASF的孵化下，多个项目成为顶级项目。
伴随着越来越多来自于中国的项目进入到ASF，中国的Committer数量也在不断增加。如图35所示，在2010之前，中国开发者参与度并不高。自2014年开始，中国Committer数量逐年递增，直至今日，中国Committer数量占到新增Committer一半左右的比例。

图35 Apache Committer总人数和中国人数
图36展示了2014年之后源自中国Apache孵化项目与所有进入到ASF的孵化项目对比，可以看到2021 年之后来自于中国的孵化项目占比越来越大。

图36：进入ASF孵化器项目数和源自中国项目数
Apache在中国举办的ASF相关会务活动


2008年12月
"Apache Beijing 2008 Meetup”在北京Intel研发中心举办，作为第一次ASF官方活动，拉开在中国传播布道的活动序幕。


2009年12月
“Apache RoadShow Asia 2009”会议在北京Intel研发中心举行，会上介绍了Apache Hadoop项目，以及与开源相关的创业与投资。


2010年7月
在复旦大学张江校区举办的“Apache RoadShow Asia 2010”会议，两天活动吸引了300多位Apache项目的粉丝参会。


2015年10月
“ Apache RoadShow China 2015 北京”活动，时隔五年，开源社将Apache路演引入中国，通过“现场+直播”的方式吸引几千人参与。


2018年10月
“Apache Committer Meetup上海”活动，聚集了Apache孵化项目的Committer与ASF官员进行深度交流。


2020年8月
“ALC Beijing Meetup”，本次沙龙是ALC Beijing成立以来首次线下活动，主要是分享开源开发经验、探讨如何让开源项目更加茁壮成长，以及分享ASF管理和运作开源项目的成功之道。


2020年10月
“COSCon China 2020&Apache RoadShow China”进行了大型五地的线上、线下混合会议。


2021年8月
“ApacheCon Asia 2021”召开，  Apache亚洲大会时隔15年之后第一次以线上会议的方式回归亚洲。在为期三天的会议中，以13个主题、150多个议题，全方位介绍ASF 40+相关项目，吸引了近30万观众观看。


2020年2月&2021年12月
2020年2月，ALC-Beijing在遵照Apache软件基金会Local Community原则下，在Apache软件基金会申请成立，ALC-Beijing是面向北京的开源社区组织。2021年12月，ALC-Shenzhen成立，吸引到深圳本地ASF项目开发人员40+。目前，ALC Beijing&ALC-Shenzhen运作日益规范，每两周的线上会议加上不定期的线下会议，让社区成员交流和合作更加充分。



### 9.5.2 Linux基金会（包括CNCF）对中国开源的贡献
Linux基金会(The Linux Foundation，简称LF)提供了一个中立、可信的中心供全世界的开发人员和企业共同开发、管理和扩展开源项目。目前,中国在开源代码贡献和项目贡献方面都在不断加速，已经成为非常重要的参与角色。以CNCF为例，通过CNCF基金会和中国开源社区的努力,源自中国的代码贡献率已跃居世界第二，来自中国的开源项目超过30个，约占所有CNCF项目的25%。
在过去20年中，Linux基金会已经从支持单个项目(Linux内核)扩展到许多不同的项目社区。超过2300名成员和数十万开发人员参与了一些最重要和最活跃的开源项目，在云、安全、区块链和Web等跨行业技术领域进行合作。
2021年，Linux基金会在其支持的数百个开放技术社区中的贡献和参与度都在持续增长。其中，中国区成员的增长更是有目共睹，单是CNCF中国区成员的增长就达到了80%。
随着对专业人员需求的增加，供应商中立的培训和认证变得越来越重要。在中国，已有超过5500人被认证为Kubernetes认证管理员。2021年，Linux基金会向全球包括中国在内的个人颁发了免费培训和认证奖学金，数百人通过与非盈利组织的合作获得了奖励。
除了以上贡献，Linux基金会也一直通过各类活动及合作为中国开源发展带来助力。


2007年，Linux基金会组织欧美资深开源开发者来北京支持COPU召开的“Linux开发者国际会议”，与国内开发者展开深入交流。


2008年，作为主要助力之一，Linux基金会助力COPU无偿聘任数十名国际开源领袖、开源大师为智囊团高级顾问，从而建立了中国的开源高地(也是创新高地、科技高地和人才高地)。


2017年，Linux基金会成立一批旗下跨界的基金会(如云原生、区块链、人工智能等)并建立孵化器，为中国和全球培养人才与发展技术作出贡献。


Linux基金会参加COPU每年一度“开源中国开源世界高峰论坛”，是圆桌会议的主力团队，主要讨论国际开源技术的发展前沿、国内外开源发展中的问题和解决方案，包括讨论开源人才培养、生态系统建设以及开源的国际合作问题。


此外，Linux基金会为不同的生态推出了许多新的基金会，越来越多的中国企业加入合作，例如RISC-V成员在2021年上半年增加一倍多，其中很多是来自中国的成员。LF AI & DATA、LF Networking、O3DF、OpenSSF、CNCF等基金会的董事会成员也有越来越多的中国企业加入，另像NextArch等由中国企业发起的开源基金会正在全球蓬勃发展。毫无疑问，中国将继续参与全球开源并发挥重要的影响力,和全世界共同构建开源产业生态。
未来,Linux基金会和中国团队将继续推动企业和社区参与全球开源合作，培养更多开源人才。

### 9.5.3 IBM对中国开源的贡献
IBM是最早的开源拥护者之一，自20世纪90年代初期开始支持Linux、Apache和Eclipse等有影响力的社区，推动开放许可、开放治理和开放标准。IBM参与的开源项目覆盖了Linux内核、开发框架、人工智能、云计算、数据科学、区块链、IoT、量子计算、芯片等技术领域(https://www.ibm.com/opensource/) 。截至目前，有超过5000名IBM员工(大量在中国)活跃在各类开源项目中，在GitHub的IBM组织里有2300余个IBM贡献的代码库(其中许多在中国开发)。与此同时，IBM帮助中国企业建立开源治理机制，发展开源文化，并积极参与开源。
IBM定期维护的“开源之道(https://developer.ibm.com/articles/cl-open-architecture-update)” ,包括IBM选择开源项目的原则并且提倡开放治理，可以帮助中国企业在参与开源时从海量的项目中进行挑选，同时通过以身作则，避免大企业垄断开源生态。
IBM一直积极为开源相关的政策标准等建言献策，比如对2022年3月征求意见的《软件供应链安全保障基本要求》的行业标准草案，以及对国家标准草案《软件供应链安全要求》提供意见，并积极为《专利审查指南》的多次修订建言。
与此同时，IBM在中国积极推广开源技术，举办了Hyperledger、Knative、Kubeflow、Istio、LoopBack、Serverless应用案例赏析等系列开源技术深度分享。
“代码集结号(Call for Code)”是IBM联合联合国人权组织等机构发起的一项全球倡议，旨在号召开发者为世界上最大的挑战创造技术解决方案，这个倡议在发起时即被IBM引入中国。2021年，大中华赛区有超过2000个团队或个人参与，在4个中国城市开展线下活动。
为便于中国开发者参与，IBM推动成立了许多开源项目的中国工作组。例如，IBM中国在2020年成立Open Horizon中国兴趣小组。2016年，IBM推动Hyperledger社区成立超级账本中国技术工作组(TWGC)，来自IBM的开源贡献者多次担任TWGC的组长。
“开放主机(OMP)”是在Linux基金会下的项目,由IBM贡献并于2015年与其他16家企业和大学共同创建。自2016年起，全球(含中国)各地优秀的学生被选拔参与该项目。截至2022年，有60+学生(含中国)参与了100+(含中国)个项目，很多学生在完成实习之后都成为了主机领域的优秀员工。
此外，IBM还为中国高校师生打造结合开源技术的前沿技术课程，如数据科学、区块链、云计算、设计思维等。利用相关的开源和IBM技术，助力老师进行课程升级和教学改革，帮助学生掌握开源技术并积累参与开源社区的经验。
IBM的开源服务和基于开源的云计算、自动化、人工智能、区块链及数据科学等产品于2021年收入中国信通院开源供应商目录第一和第二批(http://www.caict.ac.cn/xwdt/ynxw/202109/t20210926_390439.htm) 。 与此同时，IBM还跟中国信通院共同协作推广中国开源服务标准，并成为白金级合作伙伴。
为应对开源软件没有商业保证和服务级别协议的挑战，IBM在中国建设了一支有90余名工程师组成的开源专家队伍，可以对三十余种最常见的主流开源软件提供现场专家支持。其他主流开源软件也可以得到全球多个开源技术支持中心专家的迅速响应和支持。
IBM对中国开源的建议
主流开源项目和开源社区都具有服务全球用户、接受全球贡献、提倡开放治理、发言权和贡献度相匹配，以及避免个别企业试图主导或控制的特点。
在此基础上，中国的开源活动可更具全球视野，积极参与国际主流开源社区和项目，了解其发展方向并施加影响，同时在此过程中培养人才，树立中国在国际开源领域的形象，进而吸引全球开源贡献者参与中国的开源社区和项目，创造并扩大商业价值之外的附加值。
此外，需要服务水平协议和商业保证的企业用户，可以参照中国人民银行等5部委颁布的开源政策，向供应商采购基于开源的商业产品。

### 9.5.4 Intel对中国开源的贡献

过去20年，Intel持续投入全球开源项目，成为开放生态的积极贡献者。Intel的19000名软件工程师参与了100多个开源项目，贡献、管理、维护着300多个社区，在过去15年当中，Intel是Linux Kernel的最多代码贡献者，同时是重要的云原生开源社区Kubernetes的多年杰出贡献者。不仅如此，Intel还是700多家标准化组织的核心会员，并且积极投入可信计算开源项目。Intel在中国一贯坚持开放融合和本土创新，并在底层软件支持硬件平台、关键技术支持操作系统和虚拟化支持云边服务的融合等方面取得了丰硕成果。

2006年，Intel倡导并和清华大学、AKA社区合作发起了中国Linux内核开发者大会。大会逐渐发展成为中国顶级开源技术论坛，同时也挖掘了一批中国内核顶级专家。此外，Intel积极支持并赞助中国开源操作系统年会。2012年，Intel、新浪、中标软件以及上海交通大学联合成立了“中国开源云联盟”，整合中国公司的研发资源，持续推动中国开源云事业的发展。在联盟指导下，Intel于2015年联合华为发起了一系列开源黑客松活动，在2020年与业界伙伴倡导合作了云计算基础架构开发者大会，为中国开源软件的活跃和技术合作贡献了力量。

Intel在系统软件领域与业界建立了长期广泛的合作关系，积极参与中国开源操作系统社区建设。目前Intel已加入开放原子开源基金会旗下的三大主要开源系统软件社区：在龙蜥社区，Intel是创始理事会成员和技术委员会成员，在社区创建并管理了Intel架构SIG；在欧拉社区，Intel创建了类似的SIG，不断把Intel新平台和特性加入到欧拉代码仓；在OpenCloudOS社区，Intel也是创始成员和理事会成员，并当选社区副理事长单位。Intel正在把长期在开源技术领域的积累和国际开源社区的经验贡献到中国社区。

从2006年起，Intel与上海交通大学合作推出了Linux内核课程，由Intel工程师撰写课程内容并授课三年，后与交大教师联合授课。以此为基础，Intel与高教部合作，在2007年和2008年暑期于北京大学举办了面向全国多所高校的Linux内核教育的师资培训，总共培训120人次，为全国高校的Linux课程建设打下了坚实的师资基础。

在系统固件领域，Intel早在2005年就将自研的可扩展固件接口EFI贡献给业界。该接口后来演变为新一代固件BIOS的标准UEFI。此后，Intel中国的技术团队开发、贡献了EFI的参考实现TianoCore并将其开源，由TianoCore逐步演化，发展出的EDK II固件，被业界纷纷采用以取代古老的BIOS。为了把最新的系统固件技术带入中国，Intel中国的工程师们还举办了多届技术培训班，帮助中国厂商适应和迁移到基于UEFI的固件。
 
在Web领域，Intel积极推动开放Web技术与中国前端开发技术的融合。作为W3C中文兴趣小组的主席成员，Intel大力支持中国小程序生态在W3C的框架下的标准化工作，实现各种小程序之间以及Web应用之间的互联互通。Intel还邀请了领先的中国企业共同建设基础支撑技术社区。经过多年发展，这些社区现在已经由中国的贡献者所主导，并在中国产业界得到了广泛的应用。

在网络及存储优化领域，Intel是DPDK和SPDK等相关社区的主要贡献者、推动者和布道者。Intel协调组织了DPDK中国峰会和SPDK中国技术峰会，与中国主要云厂商及电信厂商建立了密切的合作关系，使DPDK和SPDK成为它们构建基础架构设施的必备组件。同时，Intel和高校密切合作，积极推动网络创新技术的发展及人才的培养。

2023年2月，Intel宣布正式成立Intel中国开源技术委员会，最大程度整合内部资源，利用Intel最新技术和生态资源，更加深入地与中国的开放生态融合，更专业高效地服务中国开发者，推动开源生态建设和产业发展。

### 9.5.5 微软对中国开源的贡献

微软对于开源领域的投入最早可以追溯至2001年Shared Source软件的开源，自此，微软开始在开源领域不断进行贡献，与开源社区共同成长，并积极参与到开源软件的贡献当中，为开源软件提供支持和帮助。每年，在微软公司内部有超过15000名工程师在GitHub上参与社区项目贡献。

在推动中国开源发展进程中，微软也发挥了重要的作用：2014年，微软开放技术作为核心初创成员，联合中国支持开源的企业、社区及个人开发者共同成立了开源社；同年，微软开源.NET并将其捐给.NET基金会，帮助开发者可以在更多场景中使用.NET来开发应用程序，Linux、macOS等平台得以运行.NET应用程序；2020年，开源社联合疫战2020公益小组，基于微软(亚洲)互联网工程院商用人工智能团队的智能对话平台，打造了智能问答机器人“小源”，提供高效、权威、准确的疫情防护问答服务；通过积极参与开源社区建设并贡献技术力量，微软已经在国内外开源社区中赢得了广泛的认可。

微软开源的Visual Studio Code也在中国开源界发挥了巨大的作用，大量的中国开发者使用Visual Studio Code开发自己的开源项目、开发基于Visual Studio Code的开源插件。Visual Studio Code成 为中国开源社区的重要组成部分。不仅如此，微软推出的TypeScript广受社区开发者的好评，成为业界JavaScript类型化的事实标准，中国开发者基于TypeScript开发出大量的优秀开源项目。
在云原生领域，微软积极参与到社区开源软件的开发和维护当中，作为CNCF基金会的白金会员，为CNCF捐赠和贡献了Kubernetes、etcd、containerd、Helm、KEDA、Virtual Kubelet、Open Service Mesh等项目。

在Kubernetes联合创始人Brendan Burns的带领下，微软常年位居Kubernetes项目的贡献者前列，累计为Kubernetes提供了超过10万次的贡献。除了参与到核心项目构建当中，微软还开源了不少云原生场景下的计算组件，帮助中国开发者更好地在社区、企业等不同规模的场景中落地云原生。

2018年，微软将收购而来的Helm捐赠给CNCF基金会，让开发者在使用Helm时再无后顾之忧；随之而来的是，微软在2019年开源了一套跨场景的分布式运行时Dapr，为中国开发者提供了应用程序的无侵入式分布式开发体验，帮助开发者更好地落地业务和应用。国内诸如阿里巴巴等企业也在自己的业务系统当中大量应用Dapr。2020年，微软开源了一套轻量级服务网格组件Open Service Mesh，并将其捐赠给CNCF基金会，帮助广大的中国开发者可以用更低成本落地服务治理，助力开发者落地微服务。

开源的影响无处不在，势不可挡，但开源不仅仅是软件和技术层面，更是工程师文化。微软会持续加大对于开源社区的投入。同时，微软在中国将继续致力于帮助中国的开源社区与全球的开源组织合作，将优秀的开源项目和文化引进中国，推动中国的开源活动和开源精神的发展；微软也会继续加速将中国的优秀开源文化、开源活动传播出去，让中国的开源文化得以被全世界的开发者们所知晓。

### 9.5.6 红帽对中国开源的贡献

《企业级开源现状：红帽调查报告2022》显示，95% 的受访者表示，企业级开源对于他们组织的整体企业基础架构非常重要。究其原因，开源开发模式可以推动并支持实现创新和敏捷 IT。技术方面，通过红帽企业 Linux 重新定义了操作系统，并打造出一系列丰富的产品组合，涵盖了混合云基础架构、中间件、敏捷集成、云原生应用开发以及管理和自动化解决方案，提供经过安全强化的开源解决方案，从核心数据中心到网络边缘，专注为企业跨平台/环境工作提供更多便利。近日正式推出了红帽企业Linux 9.2，进一步简化和优化了 Linux 平台在混合云环境下的复杂任务，弥合IT技能差距，确保运营一致性，扩展云规模上的创新；人才培养方面，持续培养开源新生力量和企业IT中坚力量，赋能IT决策者和管理者。近期，红帽和全球领先的技能和人才发展公司NIIT宣布合作，已于2023年3月1日起在中国提供红帽培训课程。中国企业和IT专业人士现在可以访问NIIT的RedHat.Training-China.com平台购买并获取红帽培训在线学习课程，打造涵盖云计算、容器、虚拟化和自动化等红帽解决方案关键领域的技能。

2011年起，针对全国大专院校计算机/软件专业学生，红帽已连续11年举办“红帽挑战赛”活动，基于广受赞誉的红帽开源软件技术培训服务，联合30多家合作伙伴，以及数百家大专院校，共同为国内培养开源软件后备专业人才，迄今已有9万余名高校学生参与其中。

2020和2021年，红帽联合国内各行业企业用户，知名企业IT社区twt及国内外生态合作伙伴，共同成功举办了两届覆盖全国/全行业的“容器云职业技能大赛”。每年都有近4000家来自银行、保险、证券、电信、制造、医疗等行业的企业用户参与，两年总计近50,000人参与大赛学习，数千人参加了最后阶段的精英比赛，并获得专业技术认证，数十个团队获奖并沉淀了近百个容器技术实践方案。

红帽中国积极利用在国际开源社区的经验、资源和影响力，支持国内开源社区及国内先行企业与国际开源社区交流合作（如OpenStack、Ceph等技术领域)，安排各类红帽技术专家，积极参与各种国际开源社区在国内的用户组组织的的技术交流活动。

小结

今年是红帽成立30周年，在华19年，在中国为中国。我们坚持使用开放透明的先进IT技术，构建全球一体化的丰富IT生态以及领先的创新商业模式，共同推动中国IT技术的创新，实现类似高铁模式的飞速发展。

### 9.5.7 OpenInfra对中国开源的贡献

OpenInfra 基金会致力于构建多元化的开源社区，推动开源基础设施软件在实际生产中的应用。OpenInfra 基金会在全球 187 个国家/地区 110,000 余名社区成员的支持下，托管开源项目并展开社区实践，涉及人工智能、容器云原生应用、边缘计算及数据中心云等领域。在中国社区，OpenInfra基金会的OpenStack，Kata Containers，以及算力网络工作组是最为广受欢迎并活跃增长的社区。

OpenStack社区在中国的增长

2022 年，中国的 OpenInfra 社区发展迅速。 凭借众多的志愿者和庞大的开源基础设施组织基础，中国仍然是世界第二大 OpenStack 社区。在过去的一年了，OpenStack 技术架构委员会提交、接受并发布了两个来自中国贡献的新项目：

●Venus project - 提供日志管理服务的一站式解决方案。
●Skyline 项目 - 由 UI 和 UE 优化的现代 OpenStack 仪表板。

Venus项目由浪潮数据发起，回馈社区。 随着发展的推进，StackHPC、中国电信和郑州云海信息科技等三个以上的组织已经开始为上游项目做出贡献。 这有助于发布全文/多维检索、典型错误分析、调用链分析等功能。

Skyline 项目最初由九州云发起并贡献。 现在有超过四个组织参与上游开发，正因为如此，它被包含在 OpenStack 第 26 版中。近期，OpenStack韩国用户小组也开始了参与Skyline项目的预研和评估工作。

除了新近发布的项目，在过去的一年里，已经与OpenStack社区中开发成长了许多年的Cyborg 继续展示其发展以及更多元化的上游社区。 在上一版中，全球有超过 25 个组织参与了 Cyborg 上游开发，其中包括一众来自中国的企业与组织。

Kata Containers社区在中国的增长

Kata Containers 在 2022 年取得了重大进展，尤其是在中国社区。

中国联通和浪潮数据发布了两个新的用户案例研究，针对 Kata 容器的大规模部署。 蚂蚁集团的 Kata Container 使用白皮书也在 2022 年发布，在全球获得了很高的知名度，甚至获得了超级用户奖。 300多位开发者在微信群里积极交流，讨论技术问题，分享部署。

2023年3月份，Kata Containers中国社区也在成都举办了疫情恢复后的第一次线下技术聚会。来自社区的30多位开发人员参加了聚会并分享各自的实践案例以及技术研发。据统计，Kata Containers上游社区去年共有来自18个组织的140多位开发者提交了1363项修改，其中将近50多位开发者来自中国，包括一些企业、科研学术机构和大学同学。

算力网络 (CFN) 工作组

2022 年，新的 算力网络（CFN）工作组成立，最初由中国移动发起。 该小组旨在利用相关技术制定应对共同挑战的解决方案，推动技术落地，逐步构建下一代开源基础设施技术。 工作组得到了广泛认可，2022 年共有 16 个组织加入工作组。目前工作组有自己的子团队，每周在微信上召开社区会议。

在社区传播方面，大部分的新闻发布、软件更新、活动分享、用户案例研究都是通过微信公众号发布的。
